/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.datahub.client.annotation.AppId;
import com.thebeastshop.datahub.client.annotation.Creator;
import com.thebeastshop.datahub.client.annotation.DataCreateTime;
import com.thebeastshop.datahub.client.annotation.DataUpdateTime;
import com.thebeastshop.datahub.client.annotation.DbId;
import com.thebeastshop.datahub.client.annotation.Reviser;
import com.thebeastshop.datahub.client.annotation.SendKey;
import com.thebeastshop.datahub.client.exception.DatahubAnnotationException;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import com.thebeastshop.datahub.common.enums.DataTypeEnum;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatahubProperty {
    public static final String COMMON_KEY_ID = "$id";
    public static final String COMMON_KEY_APP_ID = "$appId";
    public static final String COMMON_KEY_CREATOR = "$creator";
    public static final String COMMON_KEY_REVISER = "$reviser";
    public static final String COMMON_KEY_CREATE_TIME = "$createTime";
    public static final String COMMON_KEY_UPDATE_TIME = "$updateTime";
    private static final Object[] SUPPORTED_COMMON_KEYS = new Object[]{DbId.class, "$id", true, AppId.class, "$appId", false, Creator.class, "$creator", true, Reviser.class, "$reviser", true, DataCreateTime.class, "$createTime", true, DataUpdateTime.class, "$updateTime", true};
    private static final Map<Class, CommonKeyInfo> SUPPORTED_COMMON_KEY_MAP = new HashMap<Class, CommonKeyInfo>();
    private final Class entityClass;
    private final PropertyDescriptor propDes;
    protected String name;
    protected final String commonName;
    private final Annotation annotation;
    private final Class annotationType;
    protected final boolean canUse;
    protected final boolean isCommon;
    protected final boolean isSendKey;
    protected Integer sendKeyOrder;

    public DatahubProperty(Class entityClass, PropertyDescriptor propDes) {
        this.entityClass = entityClass;
        this.propDes = propDes;
        if (propDes != null) {
            this.name = propDes.getName();
            this.annotation = this.getDesignatedAnnotation(this.getAnnotations());
            this.annotationType = MetaUtils.getAnnotationClass(this.annotation);
            this.isSendKey = SendKey.class == this.annotationType;
            boolean bl = this.isCommon = this.annotation != null && !this.isSendKey;
            if (this.isCommon) {
                CommonKeyInfo info = SUPPORTED_COMMON_KEY_MAP.get(this.annotationType);
                this.commonName = info.commonName;
                this.canUse = info.canUse;
            } else {
                this.commonName = null;
                this.canUse = true;
            }
            if (this.isSendKey) {
                SendKey sendKey = (SendKey)this.annotation;
                this.sendKeyOrder = sendKey.order();
            }
        } else {
            this.commonName = null;
            this.annotation = null;
            this.annotationType = null;
            this.canUse = true;
            this.isCommon = true;
            this.isSendKey = false;
        }
    }

    private void filterAnnotations(List<Annotation> rets, Set<Class> annClasses, Annotation[] anns) {
        for (Annotation ann : anns) {
            Class annCls;
            if (!DatahubProperty.isSupportAnnotation(ann) || annClasses.contains(annCls = MetaUtils.getAnnotationClass(ann))) continue;
            rets.add(ann);
            annClasses.add(annCls);
        }
    }

    private List<Annotation> getAnnotations() {
        LinkedList<Annotation> rets = new LinkedList<Annotation>();
        Field[] fields = this.entityClass.getDeclaredFields();
        HashSet<Class> annClasses = new HashSet<Class>();
        for (Field field : fields) {
            if (!field.getName().equals(this.name)) continue;
            this.filterAnnotations(rets, annClasses, field.getDeclaredAnnotations());
        }
        Annotation[] rmtdAnns = this.propDes.getReadMethod().getAnnotations();
        this.filterAnnotations(rets, annClasses, rmtdAnns);
        Annotation[] wmtdAnns = this.propDes.getWriteMethod().getAnnotations();
        this.filterAnnotations(rets, annClasses, wmtdAnns);
        return rets;
    }

    private Annotation getDesignatedAnnotation(List<Annotation> annotations) {
        Annotation retAnn = null;
        for (Annotation ann : annotations) {
            if (!DatahubProperty.isSupportAnnotation(ann)) continue;
            this.assertAnnotation(ann);
            retAnn = ann;
        }
        return retAnn;
    }

    public String getName() {
        return this.name;
    }

    public Type getGenericPropertyType() {
        Method method = this.propDes.getWriteMethod();
        return method.getGenericParameterTypes()[0];
    }

    public boolean isCommon() {
        return this.isCommon;
    }

    public boolean isCanUse() {
        return this.canUse;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Class getAnnotationType() {
        return this.annotationType;
    }

    public static boolean isSupportAnnotation(Annotation ann) {
        Class annClass = MetaUtils.getAnnotationClass(ann);
        return DatahubProperty.isSupportAnnotation(annClass);
    }

    public static boolean isSupportAnnotation(Class annClass) {
        return SUPPORTED_COMMON_KEY_MAP.containsKey(annClass);
    }

    private void assertAnnotation(Annotation ann) {
        if (this.annotation != null && this.annotation.getClass() != ann.getClass()) {
            throw new DatahubAnnotationException(this.entityClass, this.propDes.getName(), this.annotation.getClass(), ann.getClass());
        }
    }

    public Class getPropertyType() {
        return this.propDes.getPropertyType();
    }

    public DataTypeEnum getDataType() {
        Class type = this.getPropertyType();
        DataTypeEnum dataType = DataTypeEnum.getEnumByType((Class)type);
        return dataType;
    }

    public Object getValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        Method readMethod = this.propDes.getReadMethod();
        return readMethod.invoke(bean, new Object[0]);
    }

    public void setValue(Object bean, Object value) throws InvocationTargetException, IllegalAccessException {
        Method writeMethod = this.propDes.getWriteMethod();
        writeMethod.invoke(bean, value);
    }

    public boolean hasSetter() {
        return this.propDes.getWriteMethod() != null;
    }

    static {
        for (int i = 0; i < SUPPORTED_COMMON_KEYS.length; i += 3) {
            Class annClass = (Class)SUPPORTED_COMMON_KEYS[i];
            String commonName = (String)SUPPORTED_COMMON_KEYS[i + 1];
            boolean canUse = (Boolean)SUPPORTED_COMMON_KEYS[i + 2];
            CommonKeyInfo commonKeyInfo = new CommonKeyInfo(annClass, commonName, canUse);
            SUPPORTED_COMMON_KEY_MAP.put(annClass, commonKeyInfo);
        }
    }

    static class CommonKeyInfo {
        final Class annClass;
        final String commonName;
        final boolean canUse;

        CommonKeyInfo(Class annClass, String commonName, boolean canUse) {
            this.commonName = commonName;
            this.canUse = canUse;
            this.annClass = annClass;
        }
    }
}

