/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.criteria;

import com.thebeastshop.datahub.client.criteria.Criteria;
import com.thebeastshop.datahub.client.criteria.EL;
import com.thebeastshop.datahub.client.criteria.QueryBlock;
import com.thebeastshop.datahub.client.utils.CriteriaUtils;
import com.thebeastshop.datahub.client.utils.DatahubBeanUtil;
import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import com.thebeastshop.datahub.client.utils.TypeCaster;
import com.thebeastshop.datahub.common.bgel.ELUtils;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.enums.SortEnum;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Query<T> {
    private final Class<T> entityClass;
    private final Query<T> parentQuery;
    private Boolean lastCondition;
    private List<EL> elList;
    private Criteria criteria;
    private Long startRow;
    private Long endRow;
    private Long page;
    private Long pageSize;
    private boolean reversed;
    private boolean hasCount;
    private Map<String, SortEnum> sort;

    private Query(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.parentQuery = null;
    }

    private Query(Query<T> parentQuery) {
        this.parentQuery = parentQuery;
        this.entityClass = parentQuery.getEntityClass();
    }

    public static <T> Query biz(Class<T> entityClass) {
        return new Query<T>(entityClass);
    }

    public static <T> Query from(Class<T> entityClass) {
        return new Query<T>(entityClass);
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public String getEl() {
        CriteriaNode criteriaNode = null;
        if (this.elList != null) {
            StringBuilder elBuilder = new StringBuilder();
            int len = this.elList.size();
            for (int i = 0; i < len; ++i) {
                EL el = this.elList.get(i);
                String adjustedEL = CriteriaUtils.adjustElWithArgs(el.getEl(), el.getElArgs());
                elBuilder.append(adjustedEL);
            }
            criteriaNode = ELUtils.parseEL((String)elBuilder.toString());
        } else if (this.criteria != null) {
            criteriaNode = CriteriaUtils.toCriteriaNode(this.criteria.getHead());
        }
        if (criteriaNode == null) {
            return null;
        }
        TypeCaster.cast(criteriaNode, this.entityClass);
        String parsedEl = CriteriaUtils.toELString(criteriaNode);
        return parsedEl;
    }

    public Query where(String el, Object ... args) {
        this.elList = new LinkedList<EL>();
        this.elList.add(new EL(el, args));
        return this;
    }

    public Query where(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    private Query andOr(String el, String opt, Object ... args) {
        String trimedEl;
        if (this.elList == null) {
            this.elList = new LinkedList<EL>();
        }
        if (this.elList.size() > 0 && !(trimedEl = el.trim().toLowerCase()).startsWith(opt)) {
            el = " " + opt + " " + el.trim();
        }
        this.elList.add(new EL(el, args));
        return this;
    }

    public Query and(String el, Object ... args) {
        return this.andOr(el, "and", args);
    }

    public Query or(String el, Object ... args) {
        return this.andOr(el, "or", args);
    }

    private Query ifAndOr(boolean condition, String el, String opt, Object ... args) {
        this.lastCondition = condition;
        if (!condition) {
            return this;
        }
        if (StringUtils.isBlank((CharSequence)el)) {
            return this;
        }
        return this.andOr(el, opt, args);
    }

    public Query ifAnd(boolean condition, String el, Object ... args) {
        return this.ifAndOr(condition, el, "and", args);
    }

    public Query ifOr(boolean condition, String el, Object ... args) {
        return this.ifAndOr(condition, el, "or", args);
    }

    public Query elseIfAndOr(Boolean condition, String el, String opt, Object ... args) {
        if (this.lastCondition == null) {
            throw new RuntimeException(" [DATAHUB] \u6761\u4ef6\u4e3a\u7a7a\uff01\u4e0d\u80fd\u4f7f\u7528else" + opt.substring(0, 1).toUpperCase() + opt.substring(1));
        }
        if (!this.lastCondition.booleanValue()) {
            if (condition != null) {
                return this.ifAndOr(condition, el, opt, args);
            }
            return this.andOr(el, opt, args);
        }
        return this;
    }

    public Query elseAnd(String el, Object ... args) {
        return this.elseIfAndOr(null, el, "and", args);
    }

    public Query elseOr(String el, Object ... args) {
        return this.elseIfAndOr(null, el, "or", args);
    }

    public Query elseIfAnd(boolean condition, String el, Object ... args) {
        return this.elseIfAndOr(condition, el, "and", args);
    }

    public Query elseIfOr(boolean condition, String el, Object ... args) {
        return this.elseIfAndOr(condition, el, "or", args);
    }

    private Query andOrBlock(String opt, QueryBlock block) {
        if (block == null) {
            return this;
        }
        if (this.elList == null) {
            this.elList = new LinkedList<EL>();
        }
        Query<T> subQuery = new Query<T>(this);
        block.wrap(subQuery);
        String subEl = subQuery.getEl();
        if (StringUtils.isNotBlank((CharSequence)subEl)) {
            if (this.elList.size() > 0) {
                if (!subEl.startsWith("(")) {
                    subEl = " (" + subEl + ")";
                }
                if (!subEl.startsWith(opt)) {
                    subEl = " " + opt + " " + subEl;
                }
            }
            this.elList.add(new EL(subEl));
        }
        return this;
    }

    private Query ifAndOrBlock(boolean condition, String opt, QueryBlock block) {
        if (!condition) {
            return this;
        }
        return this.andOrBlock(opt, block);
    }

    public Query ifAnd(boolean condition, QueryBlock block) {
        return this.ifAndOrBlock(condition, "and", block);
    }

    public Query ifOr(boolean condition, QueryBlock block) {
        return this.ifAndOrBlock(condition, "or", block);
    }

    public Query elseIfAndOrBlock(Boolean condition, String opt, QueryBlock block) {
        if (this.lastCondition == null) {
            throw new RuntimeException(" [DATAHUB] \u6761\u4ef6\u4e3a\u7a7a\uff01\u4e0d\u80fd\u4f7f\u7528else" + opt.substring(0, 1).toUpperCase() + opt.substring(1));
        }
        if (!this.lastCondition.booleanValue()) {
            if (condition != null) {
                return this.ifAndOrBlock(condition, opt, block);
            }
            return this.andOrBlock(opt, block);
        }
        return this;
    }

    public Query elseAnd(QueryBlock block) {
        return this.elseIfAndOrBlock(null, "and", block);
    }

    public Query elseOr(QueryBlock block) {
        return this.elseIfAndOrBlock(null, "or", block);
    }

    public Query elseIfAnd(boolean condition, QueryBlock block) {
        return this.elseIfAndOrBlock(condition, "and", block);
    }

    public Query elseIfOr(boolean condition, QueryBlock block) {
        return this.elseIfAndOrBlock(condition, "or", block);
    }

    public Long getStartRow() {
        return this.startRow;
    }

    public Query startRow(Long startRow) {
        this.startRow = startRow;
        return this;
    }

    public Long getEndRow() {
        return this.endRow;
    }

    public Query endRow(Long endRow) {
        this.endRow = endRow;
        return this;
    }

    public Long getPage() {
        return this.page;
    }

    public Query page(Integer page) {
        if (page != null) {
            this.page = page.longValue();
        }
        return this;
    }

    public Query page(Long top) {
        this.page = top;
        return this;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public Query pageSize(Integer pageSize) {
        if (pageSize != null) {
            this.pageSize = pageSize.longValue();
        }
        return this;
    }

    public Query pageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Query reversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public boolean hasCount() {
        return this.hasCount;
    }

    public Query hasCount(boolean hasCount) {
        this.hasCount = hasCount;
        return this;
    }

    public Map<String, SortEnum> getSort() {
        LinkedHashMap<String, SortEnum> retMap = new LinkedHashMap<String, SortEnum>();
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(this.entityClass);
        if (this.sort != null) {
            for (String key : this.sort.keySet()) {
                SortEnum direction = this.sort.get(key);
                DatahubProperty property = metaClass.getProperty(key);
                if (property == null) continue;
                String newKey = key;
                if (property.isCommon()) {
                    newKey = property.getCommonName();
                }
                retMap.put(newKey, direction);
            }
        }
        return retMap;
    }

    public Query sort(LinkedHashMap<String, SortEnum> sort) {
        this.sort = sort;
        return this;
    }

    public Query sortKey(String key, SortEnum sortEnum) {
        if (this.sort == null) {
            this.sort = new LinkedHashMap<String, SortEnum>();
        }
        this.sort.put(key, sortEnum);
        return this;
    }
}

