/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.criteria;

import com.thebeastshop.datahub.client.criteria.Criteria;
import com.thebeastshop.datahub.client.utils.CriteriaUtils;
import com.thebeastshop.datahub.client.utils.DatahubBeanUtil;
import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import com.thebeastshop.datahub.client.utils.TypeCaster;
import com.thebeastshop.datahub.common.bgel.ELUtils;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.enums.SortEnum;
import java.util.LinkedHashMap;
import java.util.Map;

public class Query<T> {
    private final Class<T> entityClass;
    private String el;
    private Object[] elArgs;
    private Criteria criteria;
    private Long startRow;
    private Long endRow;
    private Long page;
    private Long pageSize;
    private boolean reversed;
    private boolean hasCount;
    private Map<String, SortEnum> sort;

    public Query(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public static <T> Query biz(Class<T> entityClass) {
        return new Query<T>(entityClass);
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public String getEl() {
        CriteriaNode criteriaNode = null;
        if (this.el != null) {
            String adjustedEL = CriteriaUtils.adjustElWithArgs(this.el, this.elArgs);
            criteriaNode = ELUtils.parseEL((String)adjustedEL);
        } else if (this.criteria != null) {
            criteriaNode = CriteriaUtils.toCriteriaNode(this.criteria.getHead());
        }
        if (criteriaNode == null) {
            throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u8868\u8fbe\u5f0f\u65e0\u6cd5\u89e3\u6790");
        }
        TypeCaster.cast(criteriaNode, this.entityClass);
        String parsedEl = CriteriaUtils.toELString(criteriaNode);
        return parsedEl;
    }

    public Query where(String el, Object ... args) {
        this.el = el;
        this.elArgs = args;
        return this;
    }

    public Query where(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Long getStartRow() {
        return this.startRow;
    }

    public Query startRow(Long startRow) {
        this.startRow = startRow;
        return this;
    }

    public Long getEndRow() {
        return this.endRow;
    }

    public Query endRow(Long endRow) {
        this.endRow = endRow;
        return this;
    }

    public Long getPage() {
        return this.page;
    }

    public Query page(Integer page) {
        if (page != null) {
            this.page = page.longValue();
        }
        return this;
    }

    public Query page(Long top) {
        this.page = top;
        return this;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public Query pageSize(Integer pageSize) {
        if (pageSize != null) {
            this.pageSize = pageSize.longValue();
        }
        return this;
    }

    public Query pageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Query reversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public boolean hasCount() {
        return this.hasCount;
    }

    public Query hasCount(boolean hasCount) {
        this.hasCount = hasCount;
        return this;
    }

    public Map<String, SortEnum> getSort() {
        LinkedHashMap<String, SortEnum> retMap = new LinkedHashMap<String, SortEnum>();
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(this.entityClass);
        if (this.sort != null) {
            for (String key : this.sort.keySet()) {
                SortEnum direction = this.sort.get(key);
                DatahubProperty property = metaClass.getProperty(key);
                if (property == null) continue;
                String newKey = key;
                if (property.isCommon()) {
                    newKey = property.getCommonName();
                }
                retMap.put(newKey, direction);
            }
        }
        return retMap;
    }

    public Query sort(LinkedHashMap<String, SortEnum> sort) {
        this.sort = sort;
        return this;
    }

    public Query sortKey(String key, SortEnum sortEnum) {
        if (this.sort == null) {
            this.sort = new LinkedHashMap<String, SortEnum>();
        }
        this.sort.put(key, sortEnum);
        return this;
    }
}

