/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.thebeastshop.datahub.client.DatahubClient;
import com.thebeastshop.datahub.client.annotation.AppId;
import com.thebeastshop.datahub.client.annotation.Creator;
import com.thebeastshop.datahub.client.annotation.DataCreateTime;
import com.thebeastshop.datahub.client.annotation.DataUpdateTime;
import com.thebeastshop.datahub.client.annotation.DbId;
import com.thebeastshop.datahub.client.annotation.Reviser;
import com.thebeastshop.datahub.client.criteria.Query;
import com.thebeastshop.datahub.client.exception.DatahubCreatorEmpty;
import com.thebeastshop.datahub.client.exception.DatahubIdEmpty;
import com.thebeastshop.datahub.client.exception.DatahubQueryException;
import com.thebeastshop.datahub.client.exception.DatahubQueryResultException;
import com.thebeastshop.datahub.client.exception.DatahubReviserEmpty;
import com.thebeastshop.datahub.client.utils.CriteriaUtils;
import com.thebeastshop.datahub.client.utils.DatahubBeanUtil;
import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import com.thebeastshop.datahub.common.api.QueryResult;
import com.thebeastshop.datahub.common.api.Result;
import com.thebeastshop.datahub.common.dto.QueryNode;
import com.thebeastshop.datahub.common.enums.DataTypeEnum;
import com.thebeastshop.datahub.common.enums.MessageOperationEnum;
import com.thebeastshop.datahub.common.enums.MessageProtocolEnum;
import com.thebeastshop.datahub.common.enums.ResultCodeEnum;
import com.thebeastshop.datahub.common.vo.BusinessMessage;
import com.thebeastshop.datahub.common.vo.BusinessProperty;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import com.thebeastshop.datahub.common.vo.BusinessStruct;
import com.thebeastshop.kit.prop.PropConstants;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaDatahubClient
implements DatahubClient {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_TIMEOUT = 10;
    private static int BATCH_SIZE = 100;
    private String appId;
    private String serialization;
    private KafkaTemplate kafkaTemplate;
    private String uri;
    private final PoolingHttpClientConnectionManager poolingConnManager = new PoolingHttpClientConnectionManager();
    private RequestConfig requestConfig;

    public KafkaDatahubClient(Map<String, String> properties, KafkaTemplate KafkaTemplate2) {
        this.kafkaTemplate = KafkaTemplate2;
        String string = this.appId = StringUtils.isNotBlank((CharSequence)properties.get("appId")) ? properties.get("appId") : PropConstants.getAppId();
        if (StringUtils.isBlank((CharSequence)this.appId)) {
            throw new NoSuchFieldError("appId is blank");
        }
        this.serialization = StringUtils.isNotBlank((CharSequence)properties.get("serialization")) ? properties.get("serialization") : "kryo";
        String address = properties.get("address");
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new NoSuchFieldError("address is blank");
        }
        this.uri = !address.startsWith("http") ? "http://" + address : address;
        this.uri = this.uri + "/datahub/" + this.appId;
        this.poolingConnManager.setMaxTotal(50);
        this.poolingConnManager.setDefaultMaxPerRoute(50);
        int timeout = 10;
        if (StringUtils.isNotBlank((CharSequence)properties.get("timeout"))) {
            timeout = Integer.valueOf(properties.get("timeout"));
        }
        this.requestConfig = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }

    private HttpClient buildHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.poolingConnManager).setDefaultRequestConfig(this.requestConfig).build();
    }

    private <T> BusinessStruct convertT2Struct(T t) {
        String bizName = MetaUtils.getBusinessName(t.getClass());
        BusinessStruct struct = new BusinessStruct(bizName);
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(t.getClass());
        Map<String, DatahubProperty> allProperties = metaClass.getAllProperties();
        ArrayList properties = Lists.newArrayListWithCapacity((int)allProperties.size());
        for (DatahubProperty prop : allProperties.values()) {
            if (prop.isCommon()) continue;
            String propName = prop.getName();
            try {
                DataTypeEnum dataType = prop.getDataType();
                if (dataType == null) continue;
                Object value = prop.getValue(t);
                value = dataType.castValue(value, null);
                properties.add(new BusinessProperty(dataType, propName, value));
            }
            catch (IllegalAccessException e) {
                this.log.error("\u6cdb\u578b\u5b9e\u4f8b\u8f6c\u6362\u4e1a\u52a1\u7ed3\u6784\u51fa\u9519: \u5b57\u6bb5: {}", (Object)propName, (Object)e);
            }
            catch (InvocationTargetException e) {
                this.log.error("\u6cdb\u578b\u5b9e\u4f8b\u8f6c\u6362\u4e1a\u52a1\u7ed3\u6784\u51fa\u9519: \u5b57\u6bb5: {}", (Object)propName, (Object)e);
            }
        }
        struct.setProperties((List)properties);
        return struct;
    }

    private <T> T convertStruct2T(BusinessRecord businessRecord, Class<T> tClass) {
        T bean = null;
        try {
            bean = tClass.newInstance();
            HashMap<Class, Object> commonMap = new HashMap<Class, Object>();
            commonMap.put(DbId.class, businessRecord.getId());
            commonMap.put(AppId.class, businessRecord.getAppId());
            commonMap.put(Creator.class, businessRecord.getCreator());
            commonMap.put(Reviser.class, businessRecord.getReviser());
            commonMap.put(DataCreateTime.class, businessRecord.getCreateTime());
            commonMap.put(DataUpdateTime.class, businessRecord.getUpdateTime());
            HashMap<String, Object> bizMap = new HashMap<String, Object>();
            BusinessStruct struct = businessRecord.getBusiness();
            for (BusinessProperty property : struct.getProperties()) {
                Object val = property.getValue();
                if (val == null) continue;
                bizMap.put(property.getName(), val);
            }
            DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(tClass);
            Map<String, DatahubProperty> properties = metaClass.getAllProperties();
            for (Map.Entry<String, DatahubProperty> entry : properties.entrySet()) {
                String key = entry.getKey();
                DatahubProperty property = entry.getValue();
                Object value = property.isCommon() ? commonMap.get(property.getAnnotationType()) : bizMap.get(key);
                if (value == null) continue;
                try {
                    DataTypeEnum dataType = property.getDataType();
                    Method writerMethod = property.getPropDes().getWriteMethod();
                    Type genericType = writerMethod.getGenericParameterTypes()[0];
                    value = dataType.castValue(value, genericType);
                    property.setValue(bean, value);
                }
                catch (Throwable th) {
                    this.log.error("\u8bbe\u7f6e\u6cdb\u578b\u5b9e\u4f8b\u5c5e\u6027\u503c\u51fa\u9519: fieldName: {}", (Object)property.getName(), (Object)th);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4e1a\u52a1\u7ed3\u6784\u8f6c\u6362\u6cdb\u578b\u5b9e\u4f8b\u51fa\u9519:", (Throwable)e);
        }
        return bean;
    }

    private <T> void batchProcess(List<T> records, BatchCallback callback) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)BATCH_SIZE);
        int batch = records.size() / BATCH_SIZE;
        if (records.size() % BATCH_SIZE > 0) {
            ++batch;
        }
        this.log.info("[DATAHUB] batch start =>> batch size: " + batch);
        int offset = 0;
        for (int i = 0; i < batch; ++i) {
            list.clear();
            int batchSize = BATCH_SIZE;
            if (i == batch - 1) {
                batchSize = records.size() - BATCH_SIZE * (records.size() / BATCH_SIZE);
            }
            for (int j = 0; j < batchSize; ++j) {
                T record = records.get(offset++);
                list.add(record);
            }
            callback.call(list);
        }
    }

    @Override
    public <T> void create(T record) {
        this.batchCreate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    @Override
    public <T> void batchCreate(List<T> records) {
        this.batchProcess(records, new BatchCallback<T>(){

            @Override
            public void call(List<T> list) {
                if (CollectionUtils.isEmpty(list)) {
                    return;
                }
                ArrayList brList = Lists.newArrayListWithExpectedSize((int)list.size());
                for (Object record : list) {
                    String creator = DatahubBeanUtil.getCreator(record);
                    if (StringUtils.isBlank((CharSequence)creator)) {
                        throw new DatahubCreatorEmpty(record.getClass());
                    }
                    BusinessRecord br = new BusinessRecord();
                    br.setAppId(KafkaDatahubClient.this.appId);
                    br.setCreator(creator);
                    br.setBusiness(KafkaDatahubClient.this.convertT2Struct(record));
                    brList.add(br);
                }
                KafkaDatahubClient.this.kafkaTemplate.send("datahub", (Object)new BusinessMessage(MessageOperationEnum.CREATE, MessageProtocolEnum.valueOf((String)KafkaDatahubClient.this.serialization.toUpperCase()), (List)brList));
            }
        });
    }

    @Override
    public <T> void update(T record) {
        this.batchUpdate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    @Override
    public <T> void batchUpdate(List<T> records) {
        this.batchProcess(records, new BatchCallback<T>(){

            @Override
            public void call(List<T> list) {
                if (CollectionUtils.isEmpty(list)) {
                    return;
                }
                ArrayList brList = Lists.newArrayListWithExpectedSize((int)list.size());
                for (Object record : list) {
                    String id = DatahubBeanUtil.getId(record);
                    if (id == null) {
                        throw new DatahubIdEmpty(record.getClass(), id);
                    }
                    String reviser = DatahubBeanUtil.getReviser(record);
                    if (reviser == null) {
                        throw new DatahubReviserEmpty(record.getClass(), id);
                    }
                    BusinessRecord br = new BusinessRecord();
                    br.setId(id);
                    br.setReviser(reviser);
                    br.setAppId(KafkaDatahubClient.this.appId);
                    br.setBusiness(KafkaDatahubClient.this.convertT2Struct(record));
                    brList.add(br);
                }
                KafkaDatahubClient.this.kafkaTemplate.send("datahub", (Object)new BusinessMessage(MessageOperationEnum.UPDATE, MessageProtocolEnum.valueOf((String)KafkaDatahubClient.this.serialization.toUpperCase()), (List)brList));
            }
        });
    }

    @Override
    public <T> T getByDbId(Class<T> tClass, String dbId) {
        try {
            HttpClient httpClient = this.buildHttpClient();
            HttpGet httpGet = new HttpGet(this.uri + "/" + dbId);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String rt = EntityUtils.toString((HttpEntity)entity);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result result = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<BusinessRecord>>(){}, (Feature[])new Feature[0]);
                if (result.getCode().equals(ResultCodeEnum.OK.code)) {
                    T t = null;
                    if (result.getData() != null) {
                        t = this.convertStruct2T((BusinessRecord)result.getData(), tClass);
                    }
                    return t;
                }
                this.log.error("[DATAHUB] \u6839\u636edbId\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)result.getCode(), (Object)result.getMessage());
            }
        }
        catch (Exception e) {
            this.log.error("[DATAHUB] \u6839\u636edbId\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return null;
    }

    @Override
    public <T> QueryResult<T> find(Query query) {
        try {
            HttpClient httpClient = this.buildHttpClient();
            HttpPost httpPost = new HttpPost(this.uri + "/" + MetaUtils.getBusinessName(query.getEntityClass()) + "/search");
            QueryNode queryNode = CriteriaUtils.toQueryNode(query);
            String json = JSON.toJSONString((Object)queryNode);
            httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String rt = EntityUtils.toString((HttpEntity)entity);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result jsonResult = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<QueryResult<BusinessRecord>>>(){}, (Feature[])new Feature[0]);
                if (jsonResult.getCode().equals(ResultCodeEnum.OK.code)) {
                    ArrayList tList = null;
                    QueryResult result = new QueryResult();
                    QueryResult queryResult = (QueryResult)jsonResult.getData();
                    List businessRecords = queryResult.getData();
                    if (businessRecords != null) {
                        tList = Lists.newArrayListWithCapacity((int)businessRecords.size());
                        for (BusinessRecord businessRecord : businessRecords) {
                            Class tClass = query.getEntityClass();
                            Object t = this.convertStruct2T(businessRecord, tClass);
                            tList.add(t);
                        }
                    }
                    result.setData(tList);
                    result.setPage(queryResult.getPage());
                    result.setPageSize(queryResult.getPageSize());
                    result.setNextId(queryResult.getNextId());
                    result.setHasNextPage(queryResult.getHasNextPage());
                    result.setTotalCount(queryResult.getTotalCount());
                    return result;
                }
                this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)jsonResult.getCode(), (Object)jsonResult.getMessage());
                throw new DatahubQueryResultException(jsonResult);
            }
        }
        catch (Throwable e) {
            if (e instanceof DatahubQueryResultException) {
                throw (DatahubQueryResultException)e;
            }
            if (e instanceof SocketTimeoutException) {
                this.log.error("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", e);
                throw new RuntimeException("[DATAHUB] \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6");
            }
            this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519\uff1a", e);
            throw new DatahubQueryException(e);
        }
        return null;
    }

    static interface BatchCallback<T> {
        public void call(List<T> var1);
    }
}

