/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.google.common.collect.Maps;
import com.thebeastshop.datahub.client.annotation.AppId;
import com.thebeastshop.datahub.client.annotation.Creator;
import com.thebeastshop.datahub.client.annotation.DataCreateTime;
import com.thebeastshop.datahub.client.annotation.DataUpdateTime;
import com.thebeastshop.datahub.client.annotation.DbId;
import com.thebeastshop.datahub.client.annotation.Reviser;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class DatahubMetaClass {
    private final String name;
    private final Class entityClass;
    private Map<String, DatahubProperty> businessProperties = new HashMap<String, DatahubProperty>();
    private Map<String, DatahubProperty> commonProperties = new HashMap<String, DatahubProperty>();

    DatahubMetaClass(Class entityClass, String name) {
        this.entityClass = entityClass;
        this.name = name;
        this.parseProperties();
    }

    private void parseProperties() {
        PropertyDescriptor[] targetPds;
        for (PropertyDescriptor propDes : targetPds = BeanUtils.getPropertyDescriptors((Class)this.entityClass)) {
            if (propDes.getName().equals("class")) continue;
            DatahubProperty property = new DatahubProperty(this.entityClass, propDes);
            if (property.isCommon()) {
                this.commonProperties.put(property.getAnnotationType().getSimpleName(), property);
                continue;
            }
            this.businessProperties.put(property.getName(), property);
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public DatahubProperty getBusinessProperty(String name) {
        return this.businessProperties.get(name);
    }

    public Map<String, DatahubProperty> getBusinessProperties() {
        return this.businessProperties;
    }

    public Map<String, DatahubProperty> getCommonProperties() {
        return this.commonProperties;
    }

    public Map<String, DatahubProperty> getAllProperties() {
        HashMap allMap = Maps.newHashMap(this.commonProperties);
        allMap.putAll(this.businessProperties);
        return allMap;
    }

    public DatahubProperty getCommonProperty(Class annClass) {
        if (!DatahubProperty.isSupportAnnotation(annClass)) {
            return null;
        }
        return this.commonProperties.get(annClass.getSimpleName());
    }

    public DatahubProperty getRowKeyProperty() {
        return this.getCommonProperty(DbId.class);
    }

    public boolean isCommonProperty(String propertyName) {
        return !this.isBusinessProperty(propertyName);
    }

    public boolean isBusinessProperty(String propertyName) {
        return this.businessProperties.containsKey(propertyName);
    }

    public DatahubProperty getAppIdProperty() {
        return this.getCommonProperty(AppId.class);
    }

    public DatahubProperty getCreatorProperty() {
        return this.getCommonProperty(Creator.class);
    }

    public DatahubProperty getReviserProperty() {
        return this.getCommonProperty(Reviser.class);
    }

    public DatahubProperty getCreateTimeProperty() {
        return this.getCommonProperty(DataCreateTime.class);
    }

    public DatahubProperty getUpdateTimeProperty() {
        return this.getCommonProperty(DataUpdateTime.class);
    }

    public <T> T getCommonPropertyValue(Object bean, Class annClass, Class<T> returnClass) throws InvocationTargetException, IllegalAccessException {
        DatahubProperty property = this.getCommonProperty(annClass);
        if (property == null) {
            return null;
        }
        Object obj = property.getValue(bean);
        if (obj == null) {
            return null;
        }
        if (CharSequence.class.isAssignableFrom(returnClass)) {
            return (T)obj.toString();
        }
        return (T)obj;
    }

    public String getIdValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, DbId.class, String.class);
    }

    public String getAppIdValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, AppId.class, String.class);
    }

    public String getCreatorValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, Creator.class, String.class);
    }

    public String getReviserValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, Reviser.class, String.class);
    }

    public Date getCreateTimeValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, DataCreateTime.class, Date.class);
    }

    public Date getUpdateTimeValue(Object bean) throws InvocationTargetException, IllegalAccessException {
        return this.getCommonPropertyValue(bean, DataUpdateTime.class, Date.class);
    }
}

