/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.datahub.client.criteria.Criteria;
import com.thebeastshop.datahub.client.criteria.Query;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.dto.QueryNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CriteriaUtils {
    public static QueryNode toQueryNode(Query query) {
        QueryNode node = new QueryNode();
        node.setEl(query.getEl());
        node.setStartRowKey(query.getStartRow());
        node.setPage(query.getPage());
        node.setPageSize(query.getPageSize());
        node.setReversed(query.isReversed());
        node.setHasCount(query.hasCount());
        return node;
    }

    public static CriteriaNode toCriteriaNode(Criteria criteria) {
        CriteriaNode node = new CriteriaNode();
        CriteriaUtils.setupNode(node, criteria);
        Criteria right = criteria.getRight();
        List<Criteria> chain = criteria.getCriteriaChain();
        if (criteria.getOp() == CriteriaOperatorEnum.OR) {
            node.setKey(null);
            node.setValue(null);
            LinkedList<CriteriaNode> nodeList = new LinkedList<CriteriaNode>();
            for (Criteria orItem : chain) {
                CriteriaNode orNode = CriteriaUtils.toCriteriaNode(orItem);
                nodeList.add(orNode);
            }
            node.setChildren(nodeList);
        }
        if (right == null) {
            return node;
        }
        if (criteria == criteria.getHead()) {
            CriteriaNode andNode = new CriteriaNode();
            andNode.setOp(CriteriaOperatorEnum.AND);
            LinkedList<CriteriaNode> nodeList = new LinkedList<CriteriaNode>();
            nodeList.add(node);
            while (right != null) {
                CriteriaNode childNode = CriteriaUtils.toCriteriaNode(right);
                nodeList.add(childNode);
                right = right.getRight();
            }
            andNode.setChildren(nodeList);
            return andNode;
        }
        return node;
    }

    private static CriteriaNode setupNode(CriteriaNode node, Criteria criteria) {
        node.setKey(criteria.getKey());
        node.setOp(criteria.getOp());
        node.setValue(criteria.getValue());
        return node;
    }

    public static String toELString(CriteriaNode criteriaNode) {
        if (criteriaNode == null) {
            return null;
        }
        CriteriaOperatorEnum op = criteriaNode.getOp();
        String key = criteriaNode.getKey();
        switch (op) {
            case AND: {
                return CriteriaUtils.joinChildrenToEL(criteriaNode, "and");
            }
            case OR: {
                return CriteriaUtils.joinChildrenToEL(criteriaNode, "or");
            }
            case LT: {
                return key + "<" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case GT: {
                return key + ">" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case LE: {
                return key + "<=" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case GE: {
                return key + ">=" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case EQ: {
                return key + "==" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case NE: {
                return key + "!=" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case IN: {
                return key + " in " + CriteriaUtils.valueToEL(criteriaNode);
            }
        }
        throw new RuntimeException("[DataHub] Operator '" + op + "' is not supported!");
    }

    public static String valueToEL(Object value) {
        if (value instanceof Long) {
            return value + "L";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            return format.format(value);
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder("[");
            Iterator iter = ((List)value).iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                String itemEL = CriteriaUtils.valueToEL(item);
                builder.append(itemEL);
                if (!iter.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }
        return "\"" + value + "\"";
    }

    private static String valueToEL(CriteriaNode criteriaNode) {
        return CriteriaUtils.valueToEL(criteriaNode.getValue());
    }

    private static String joinChildrenToEL(CriteriaNode criteriaNode, String op) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        List children = criteriaNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            String childEl = CriteriaUtils.toELString((CriteriaNode)children.get(i));
            builder.append(childEl);
            if (i >= children.size() - 1) continue;
            builder.append(' ');
            builder.append(op);
            builder.append(' ');
        }
        builder.append(")");
        return builder.toString();
    }

    public static String adjustElWithArgs(String el, Object ... args) {
        if (args != null && args.length > 0) {
            Object[] elArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                elArgs[i] = CriteriaUtils.valueToEL(args[i]);
            }
            String parsedEl = MessageFormat.format(el, elArgs);
            return parsedEl;
        }
        return el;
    }
}

