/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.thebeastshop.datahub.api.QueryResult;
import com.thebeastshop.datahub.client.DatahubClient;
import com.thebeastshop.datahub.client.annotation.AppId;
import com.thebeastshop.datahub.client.annotation.Creator;
import com.thebeastshop.datahub.client.annotation.DataCreateTime;
import com.thebeastshop.datahub.client.annotation.DataUpdateTime;
import com.thebeastshop.datahub.client.annotation.Reviser;
import com.thebeastshop.datahub.client.annotation.RowKey;
import com.thebeastshop.datahub.client.criteria.Query;
import com.thebeastshop.datahub.client.exception.DatahubCreatorEmpty;
import com.thebeastshop.datahub.client.exception.DatahubQueryException;
import com.thebeastshop.datahub.client.exception.DatahubQueryResultException;
import com.thebeastshop.datahub.client.exception.DatahubReviserEmpty;
import com.thebeastshop.datahub.client.exception.DatahubRowKeyEmpty;
import com.thebeastshop.datahub.client.utils.CriteriaUtils;
import com.thebeastshop.datahub.client.utils.DatahubBeanUtil;
import com.thebeastshop.datahub.client.utils.DatahubMetaClass;
import com.thebeastshop.datahub.client.utils.DatahubProperty;
import com.thebeastshop.datahub.client.utils.MetaUtils;
import com.thebeastshop.datahub.common.api.Result;
import com.thebeastshop.datahub.common.dto.QueryNode;
import com.thebeastshop.datahub.common.enums.DataTypeEnum;
import com.thebeastshop.datahub.common.enums.ResultCodeEnum;
import com.thebeastshop.datahub.common.utils.KafkaTopicUtils;
import com.thebeastshop.datahub.common.vo.BusinessMessage;
import com.thebeastshop.datahub.common.vo.BusinessProperty;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import com.thebeastshop.datahub.common.vo.BusinessStruct;
import com.thebeastshop.kit.prop.PropConstants;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaDatahubClient
implements DatahubClient {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_TIMEOUT = 10;
    private String appId;
    private String uri;
    private String protocol = "kryo";
    private KafkaTemplate kafkaTemplate;
    private final PoolingHttpClientConnectionManager poolingConnManager = new PoolingHttpClientConnectionManager();
    private RequestConfig requestConfig;

    public KafkaDatahubClient(Map<String, String> properties, KafkaTemplate KafkaTemplate2) {
        this.kafkaTemplate = KafkaTemplate2;
        String string = this.appId = StringUtils.isNotBlank((CharSequence)properties.get("appId")) ? properties.get("appId") : PropConstants.getAppId();
        if (StringUtils.isBlank((CharSequence)this.appId)) {
            throw new NoSuchFieldError("appId is blank");
        }
        String address = properties.get("address");
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new NoSuchFieldError("address is blank");
        }
        this.uri = !address.startsWith("http") ? "http://" + address : address;
        this.uri = this.uri + "/datahub/" + this.appId;
        this.poolingConnManager.setMaxTotal(50);
        this.poolingConnManager.setDefaultMaxPerRoute(50);
        int timeout = 10;
        if (StringUtils.isNotBlank((CharSequence)properties.get("timeout"))) {
            timeout = Integer.valueOf(properties.get("timeout"));
        }
        this.requestConfig = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }

    private void init() {
    }

    private HttpClient buildHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.poolingConnManager).setDefaultRequestConfig(this.requestConfig).build();
    }

    private <T> BusinessStruct convertT2Struct(T t) {
        String bizName = MetaUtils.getBusinessName(t.getClass());
        BusinessStruct struct = new BusinessStruct(bizName);
        Field[] fields = t.getClass().getDeclaredFields();
        ArrayList properties = Lists.newArrayListWithCapacity((int)fields.length);
        DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(t.getClass());
        for (Field field : fields) {
            String fieldName = field.getName();
            if (!metaClass.isBusinessProperty(fieldName)) continue;
            field.setAccessible(true);
            try {
                DataTypeEnum dataType = DataTypeEnum.getEnumByType(field.getType());
                if (dataType == null) continue;
                Object value = dataType.castValue(field.get(t));
                properties.add(new BusinessProperty(dataType, fieldName, value));
            }
            catch (IllegalAccessException e) {
                this.log.error("\u6cdb\u578b\u5b9e\u4f8b\u8f6c\u6362\u4e1a\u52a1\u7ed3\u6784\u51fa\u9519: fieldName: {}", (Object)fieldName, (Object)e);
            }
        }
        struct.setProperties((List)properties);
        return struct;
    }

    private <T> T convertStruct2T(BusinessRecord businessRecord, Class<T> tClass) {
        T bean = null;
        try {
            bean = tClass.newInstance();
            HashMap<Class, Object> commonMap = new HashMap<Class, Object>();
            commonMap.put(RowKey.class, businessRecord.getRowKey());
            commonMap.put(AppId.class, businessRecord.getAppId());
            commonMap.put(Creator.class, businessRecord.getCreator());
            commonMap.put(Reviser.class, businessRecord.getReviser());
            commonMap.put(DataCreateTime.class, businessRecord.getCreateTime());
            commonMap.put(DataUpdateTime.class, businessRecord.getUpdateTime());
            HashMap<String, Object> bizMap = new HashMap<String, Object>();
            BusinessStruct struct = businessRecord.getBusiness();
            for (BusinessProperty property : struct.getProperties()) {
                if (property.getValue() == null) continue;
                bizMap.put(property.getName(), property.getValue());
            }
            DatahubMetaClass metaClass = DatahubBeanUtil.getMetaClass(tClass);
            Map<Class, DatahubProperty> commonProperties = metaClass.getCommonProperties();
            for (Map.Entry<Class, DatahubProperty> entry : commonProperties.entrySet()) {
                Class keyClass = entry.getKey();
                DatahubProperty commonProperty = entry.getValue();
                Object value = commonMap.get(keyClass);
                try {
                    value = this.parseValue(value, commonProperty);
                    commonProperty.setValue(bean, value);
                }
                catch (Throwable th) {
                    this.log.error("\u8bbe\u7f6e\u6cdb\u578b\u5b9e\u4f8b\u5c5e\u6027\u503c\u51fa\u9519: fieldName: {}", (Object)commonProperty.getName(), (Object)th);
                }
            }
            Map<String, DatahubProperty> businessProperties = metaClass.getBusinessProperties();
            for (Map.Entry<String, DatahubProperty> entry : businessProperties.entrySet()) {
                String key = entry.getKey();
                DatahubProperty businessProperty = entry.getValue();
                Object value = bizMap.get(key);
                try {
                    value = this.parseValue(value, businessProperty);
                    businessProperty.setValue(bean, value);
                }
                catch (Throwable th) {
                    this.log.error("\u8bbe\u7f6e\u6cdb\u578b\u5b9e\u4f8b\u5c5e\u6027\u503c\u51fa\u9519: fieldName: {}", (Object)businessProperty.getName(), (Object)th);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4e1a\u52a1\u7ed3\u6784\u8f6c\u6362\u6cdb\u578b\u5b9e\u4f8b\u51fa\u9519:", (Throwable)e);
        }
        return bean;
    }

    private Object parseValue(Object value, DatahubProperty businessProperty) {
        if (value == null) {
            return null;
        }
        DataTypeEnum dataType = businessProperty.getDataType();
        Method writerMethod = businessProperty.getPropDes().getWriteMethod();
        Class<?> normalType = writerMethod.getParameterTypes()[0];
        Type genericType = writerMethod.getGenericParameterTypes()[0];
        switch (dataType) {
            case LIST: {
                Class listClass = (Class)((ParameterizedType)genericType).getRawType();
                if (!List.class.isAssignableFrom(listClass)) break;
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                String json = value.toString();
                if (!StringUtils.isNotBlank((CharSequence)json)) break;
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = JSON.parse((String)json).toString();
                }
                List list = JSON.parseArray((String)json, (Class)((Class)types[0]));
                return list;
            }
            case MAP: {
                String json;
                Class mapClass = (Class)((ParameterizedType)genericType).getRawType();
                if (!Map.class.isAssignableFrom(mapClass) || !StringUtils.isNotBlank((CharSequence)(json = value.toString()))) break;
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = JSON.parse((String)json).toString();
                }
                Map mapValue = (Map)JSON.parseObject((String)json, (Type)genericType, (Feature[])new Feature[0]);
                return mapValue;
            }
            case ENUM: {
                String str = value.toString();
                Object enumValue = Enum.valueOf(normalType, str);
                return enumValue;
            }
            case OBJECT: {
                String json = value.toString();
                if (!StringUtils.isNotBlank((CharSequence)json)) break;
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = JSON.parse((String)json).toString();
                }
                Object objValue = JSON.parseObject((String)json, (Type)genericType, (Feature[])new Feature[0]);
                return objValue;
            }
            default: {
                Object otherValue = dataType.castValue(value);
                return otherValue;
            }
        }
        return null;
    }

    @Override
    public <T> void create(T record) {
        this.batchCreate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    @Override
    public <T> void batchCreate(List<T> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        ArrayList brList = Lists.newArrayListWithExpectedSize((int)records.size());
        for (T record : records) {
            BusinessRecord br = new BusinessRecord();
            br.setAppId(this.appId);
            String creator = DatahubBeanUtil.getCreator(record);
            if (StringUtils.isBlank((CharSequence)creator)) {
                throw new DatahubCreatorEmpty(record.getClass());
            }
            br.setCreator(creator);
            br.setBusiness(this.convertT2Struct(record));
            brList.add(br);
        }
        this.kafkaTemplate.send(KafkaTopicUtils.createTopic((String)this.protocol), (Object)"create", (Object)new BusinessMessage((List)brList));
    }

    @Override
    public <T> void update(T record) {
        this.batchUpdate(Lists.newArrayList((Object[])new Object[]{record}));
    }

    @Override
    public <T> void batchUpdate(List<T> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        ArrayList brList = Lists.newArrayListWithExpectedSize((int)records.size());
        for (T record : records) {
            BusinessRecord br = new BusinessRecord();
            Long rowKey = DatahubBeanUtil.getRowKey(record);
            if (rowKey == null) {
                throw new DatahubRowKeyEmpty(record.getClass());
            }
            String reviser = DatahubBeanUtil.getReviser(record);
            if (reviser == null) {
                throw new DatahubReviserEmpty(record.getClass(), rowKey);
            }
            br.setRowKey(rowKey);
            br.setReviser(reviser);
            br.setAppId(this.appId);
            br.setBusiness(this.convertT2Struct(record));
            brList.add(br);
        }
        this.kafkaTemplate.send(KafkaTopicUtils.createTopic((String)this.protocol), (Object)"update", (Object)new BusinessMessage((List)brList));
    }

    @Override
    public <T> T getByRowKey(Class<T> tClass, Long rowKey) {
        try {
            HttpClient httpClient = this.buildHttpClient();
            HttpGet httpGet = new HttpGet(this.uri + "/" + rowKey);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String rt = EntityUtils.toString((HttpEntity)entity);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result result = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<BusinessRecord>>(){}, (Feature[])new Feature[0]);
                if (result.getCode().equals(ResultCodeEnum.OK.code)) {
                    T t = null;
                    if (result.getData() != null) {
                        t = this.convertStruct2T((BusinessRecord)result.getData(), tClass);
                    }
                    return t;
                }
                this.log.error("[DATAHUB] \u6839\u636erowKey\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)result.getCode(), (Object)result.getMessage());
            }
        }
        catch (Exception e) {
            this.log.error("[DATAHUB] \u6839\u636erowKey\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
        return null;
    }

    @Override
    public <T> QueryResult<T> find(Query query) {
        try {
            HttpClient httpClient = this.buildHttpClient();
            HttpPost httpPost = new HttpPost(this.uri + "/" + MetaUtils.getBusinessName(query.getEntityClass()) + "/search");
            QueryNode queryNode = CriteriaUtils.toQueryNode(query);
            String json = JSON.toJSONString((Object)queryNode);
            httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String rt = EntityUtils.toString((HttpEntity)entity);
            if (StringUtils.isNotBlank((CharSequence)rt)) {
                Result jsonResult = (Result)JSON.parseObject((String)rt, (TypeReference)new TypeReference<Result<QueryResult<BusinessRecord>>>(){}, (Feature[])new Feature[0]);
                if (jsonResult.getCode().equals(ResultCodeEnum.OK.code)) {
                    ArrayList tList = null;
                    QueryResult result = new QueryResult();
                    QueryResult queryResult = (QueryResult)jsonResult.getData();
                    List businessRecords = queryResult.getData();
                    if (CollectionUtils.isNotEmpty((Collection)businessRecords)) {
                        tList = Lists.newArrayListWithCapacity((int)businessRecords.size());
                        for (BusinessRecord businessRecord : businessRecords) {
                            Class tClass = query.getEntityClass();
                            Object t = this.convertStruct2T(businessRecord, tClass);
                            tList.add(t);
                        }
                    }
                    result.setData(tList);
                    result.setNextRowKey(queryResult.getNextRowKey());
                    result.setHasNextPage(queryResult.getHasNextPage());
                    result.setTotalCount(queryResult.getTotalCount());
                    return result;
                }
                this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55api\u51fa\u9519: code: {}, message: {}", (Object)jsonResult.getCode(), (Object)jsonResult.getMessage());
                throw new DatahubQueryResultException(jsonResult);
            }
        }
        catch (Throwable e) {
            if (e instanceof DatahubQueryResultException) {
                throw (DatahubQueryResultException)e;
            }
            this.log.error("[DATAHUB] \u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u51fa\u9519", e);
            throw new DatahubQueryException(e);
        }
        return null;
    }
}

