package com.thebeastshop.common.prop;

import com.ctrip.framework.apollo.spring.annotation.SpringValueProcessor;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinitionProcessor;
import com.ctrip.framework.apollo.spring.util.BeanRegistrationUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2019-03-06 17:47
 */
public class PropConstantsProcessor extends PropConstants implements BeanDefinitionRegistryPostProcessor {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesPlaceholderConfigurer.class.getName(), PropertySourcesPlaceholderConfigurer.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropAnnotationProcessor.class.getName(), PropAnnotationProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueProcessor.class.getName(), SpringValueProcessor.class);
//        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, ApolloJsonValueProcessor.class.getName(), ApolloJsonValueProcessor.class);
        this.processSpringValueDefinition(registry);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (INITIALIZED.compareAndSet(false, true)) {
            try {
                initializeProperties();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

    }

    private void processSpringValueDefinition(BeanDefinitionRegistry registry) {
        SpringValueDefinitionProcessor springValueDefinitionProcessor = new SpringValueDefinitionProcessor();
        springValueDefinitionProcessor.postProcessBeanDefinitionRegistry(registry);
    }

}
