/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerator {
    private final Logger log = LoggerFactory.getLogger(CodeGenerator.class);
    private static CodeGenerator instance;
    private Configuration cfg = new Configuration();
    private Map<String, Template> __cachedTemplateMap = new ConcurrentHashMap<String, Template>();

    private CodeGenerator() {
    }

    public void addCodeTemplate(String codeTemplateName, String source) {
        try {
            Template tpl = new Template(codeTemplateName, source, this.cfg);
            this.__cachedTemplateMap.put(codeTemplateName, tpl);
        }
        catch (IOException e) {
            throw new RuntimeException("\u521b\u5efacode\u6a21\u677f\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeGenerator getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<CodeGenerator> clazz = CodeGenerator.class;
        synchronized (CodeGenerator.class) {
            if (instance == null) {
                instance = new CodeGenerator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String generate(String codeTemplateName, Map<String, Object> params) {
        String result;
        Template tpl = this.__cachedTemplateMap.get(codeTemplateName);
        if (tpl == null) {
            throw new IllegalArgumentException("can't find template for name : " + codeTemplateName);
        }
        StringWriter sw = new StringWriter();
        try {
            tpl.process(params, (Writer)sw);
            result = sw.toString().toUpperCase();
        }
        catch (Exception e) {
            this.log.warn("", (Throwable)e);
            throw new RuntimeException("CodeGenerator.generate failed : " + codeTemplateName + " : " + params);
        }
        return result;
    }
}

