/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.prop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtil.class);
    private static final String UNIX_SERVER_SIDE_APP_CONFIG_PATH = "/data/appdatas/{app.id}/server.properties";
    private static final String WIN_SERVER_SIDE_APP_CONFIG_PATH = "C:/data/appdatas/{app.id}/server.properties";
    private static final String UNIX_SERVER_SIDE_CONFIG_PATH = "/data/appdatas/server.properties";
    private static final String WIN_SERVER_SIDE_CONFIG_PATH = "C:/data/appdatas/server.properties";
    private static String serverSideAppConfigPath;
    private static String serverSideConfigPath;
    private static Properties serviceProps;
    private static Properties appProps;
    private static Properties serverSideAppProps;
    private static Properties serverSideProps;
    private static final String appId;
    private static final String appName;

    ServiceUtil() {
    }

    private static void initServiceProperties() {
        String file = "/META-INF/service.properties";
        URL fileURL = ServiceUtil.class.getResource(file);
        serviceProps = new Properties();
        if (fileURL != null) {
            try {
                serviceProps.load(ServiceUtil.class.getResourceAsStream(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initAppProperties() {
        String file = "/META-INF/app.properties";
        URL fileURL = ServiceUtil.class.getResource(file);
        appProps = new Properties();
        if (fileURL != null) {
            try {
                appProps.load(ServiceUtil.class.getResourceAsStream(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initServerSideAppConfProperties() {
        serverSideAppProps = new Properties();
        if (serverSideAppConfigPath == null) {
            return;
        }
        File file = new File(serverSideAppConfigPath);
        if (file.exists() && file.isFile()) {
            try {
                serverSideAppProps.load(new FileInputStream(file));
                log.info("server side app config properties size: " + serverSideAppProps.stringPropertyNames().size());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void initServerSideConfProperties() {
        if (serverSideConfigPath == null) {
            return;
        }
        serverSideProps = new Properties();
        File file = new File(serverSideConfigPath);
        if (file.exists() && file.isFile()) {
            try {
                serverSideProps.load(new FileInputStream(file));
                log.info("server side config properties size: " + serverSideProps.stringPropertyNames().size());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getAppId() {
        return appId;
    }

    public static String getAppName() {
        return appName;
    }

    public static String getServiceProperty(String name) {
        return serviceProps.getProperty(name);
    }

    public static String getAppProperty(String name) {
        return appProps.getProperty(name);
    }

    public static String getServerSideAppProperty(String name) {
        return serverSideAppProps.getProperty(name);
    }

    public static String getServerSideProperty(String name) {
        return serverSideProps.getProperty(name);
    }

    static {
        ServiceUtil.initServiceProperties();
        ServiceUtil.initAppProperties();
        appId = ServiceUtil.getAppProperty("app.id");
        appName = ServiceUtil.getAppProperty("app.name");
        String os = System.getProperty("os.name");
        log.info("OS Name: " + os);
        if (os.toLowerCase().startsWith("win")) {
            log.info("read windows server side config file");
            if (appId != null) {
                serverSideAppConfigPath = WIN_SERVER_SIDE_APP_CONFIG_PATH.replaceAll("\\{app\\.id\\}", appId);
                serverSideConfigPath = WIN_SERVER_SIDE_CONFIG_PATH;
            }
        } else {
            log.info("read unix server side config file");
            if (appId != null) {
                serverSideAppConfigPath = UNIX_SERVER_SIDE_APP_CONFIG_PATH.replaceAll("\\{app\\.id\\}", appId);
                serverSideConfigPath = UNIX_SERVER_SIDE_CONFIG_PATH;
            }
        }
        ServiceUtil.initServerSideAppConfProperties();
        ServiceUtil.initServerSideConfProperties();
    }
}

