/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.google.common.collect.Lists;
import com.thebeastshop.common.redis.RedisNamedScript;
import com.thebeastshop.common.redis.RedisScriptManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RMap;
import org.redisson.api.RMapAsync;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.codec.KryoCodec;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RedissonClient redissonClient;
    private RedisScriptManager redisScriptManager = RedisScriptManager.scriptManager();
    private Map<Integer, RedissonClient> otherRedissClientMap = new HashMap<Integer, RedissonClient>();
    private RedisConnection redisConnection;

    public boolean hasKey(String key) {
        return this.redissonClient.getBucket(key).isExists();
    }

    public <T> Map<String, T> mutiGet(List<String> keys) {
        return this.redissonClient.getBuckets().get(keys.toArray(new String[keys.size()]));
    }

    public <T> Map<String, T> mutiGet(String ... keys) {
        return this.mutiGet(Lists.newArrayList((Object[])keys));
    }

    public <T> void putCache(String key, T t, Long timeOut) {
        this.putCache(key, t, timeOut, TimeUnit.SECONDS, (Codec)new JsonJacksonCodec());
    }

    public <T> void putCache(String key, T t, Long timeOut, TimeUnit unit) {
        this.putCache(key, t, timeOut, unit, (Codec)new JsonJacksonCodec());
    }

    public <T> void putCache(String key, T t) {
        this.putCache(key, t, null, null, (Codec)new JsonJacksonCodec());
    }

    public void putStringCache(String key, String value) {
        this.putCache(key, value, null, null, (Codec)new StringCodec());
    }

    public void putIntegerCache(String key, Integer value) {
        this.putCache(key, value, null, null, (Codec)new StringCodec());
    }

    public void putLongCache(String key, Long value) {
        this.putCache(key, value, null, null, (Codec)new StringCodec());
    }

    public <T> void putByteCache(String key, T t) {
        this.putCache(key, t, null, null, (Codec)new KryoCodec());
    }

    public <T> void putByteCache(String key, T t, Long timeout, TimeUnit unit) {
        this.putCache(key, t, timeout, unit, (Codec)new KryoCodec());
    }

    public <T> void putCommCache(String key, T t) {
        this.putCommCache(key, t, null, null);
    }

    public <T> void putCommCache(String key, T t, Long timeout, TimeUnit unit) {
        if (this.otherRedissClientMap.get(0) == null) {
            this.initOtherRedissonClient(0);
        }
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"set");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBucket bucket = this.otherRedissClientMap.get(0).getBucket(key);
            if (timeout == null) {
                bucket.set(t);
            } else {
                bucket.set(t, timeout.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putCacheWithDbIndex(Integer dbIndex, String key, T t, Long timeout, TimeUnit unit) {
        if (this.otherRedissClientMap.get(dbIndex) == null) {
            this.initOtherRedissonClient(dbIndex);
        }
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"set");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBucket bucket = this.otherRedissClientMap.get(dbIndex).getBucket(key);
            if (timeout == null) {
                bucket.set(t);
            } else {
                bucket.set(t, timeout.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    private <T> void putCache(String key, T t, Long timeOut, TimeUnit unit, Codec codec) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"set");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBucket bucket = this.redissonClient.getBucket(key, codec);
            if (timeOut == null) {
                bucket.set(t);
            } else {
                bucket.set(t, timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putCacheAsyn(String key, T t) {
        this.putCacheAsyn(key, t, null, null);
    }

    public <T> void putCacheAsyn(String key, T t, Long timeOut, TimeUnit unit) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"set");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBucket bucket = this.redissonClient.getBucket(key);
            if (timeOut == null) {
                bucket.setAsync(t);
            } else {
                bucket.setAsync(t, timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putAllCache(Map<String, T> map, Long liveTimeSec) {
        try {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync rMapAsync = null;
            for (Map.Entry<String, T> entry : map.entrySet()) {
                rMapAsync = batch.getBucket(entry.getKey());
                rMapAsync.setAsync(entry.getValue(), liveTimeSec.longValue(), TimeUnit.SECONDS);
            }
            batch.execute();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public <T> void putAllCache(Map<String, T> map) {
        try {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync rMapAsync = null;
            for (Map.Entry<String, T> entry : map.entrySet()) {
                rMapAsync = batch.getBucket(entry.getKey());
                rMapAsync.setAsync(entry.getValue());
            }
            batch.execute();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public <T> void putAllStringCache(Map<String, String> map, Long liveTimeSec) {
        try {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync rMapAsync = null;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                rMapAsync = batch.getBucket(entry.getKey(), (Codec)new StringCodec());
                rMapAsync.setAsync((Object)entry.getValue(), liveTimeSec.longValue(), TimeUnit.SECONDS);
            }
            batch.execute();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public <T> void putAllStringCache(Map<String, String> map) {
        try {
            RBatch batch = this.redissonClient.createBatch();
            RBucketAsync rMapAsync = null;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                rMapAsync = batch.getBucket(entry.getKey(), (Codec)new StringCodec());
                rMapAsync.setAsync((Object)entry.getValue());
            }
            batch.execute();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public <T> T getCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redissonClient.getBucket(key).get();
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> T getSimpleJsonCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBucket bucket = this.redissonClient.getBucket(key, (Codec)new StringCodec());
            String str = (String)bucket.get();
            Object t = JSONObject.parseObject((String)str, (TypeReference)new TypeReference<T>(){}, (Feature[])new Feature[0]);
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public String getStringCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            String str = (String)this.redissonClient.getBucket(key, (Codec)new StringCodec()).get();
            trans.setSuccessStatus();
            String string = str;
            return string;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public Integer getIntegerCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            String str = (String)this.redissonClient.getBucket(key, (Codec)new StringCodec()).get();
            trans.setSuccessStatus();
            Integer n = Integer.parseInt(str);
            return n;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public Long getLongCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            String str = (String)this.redissonClient.getBucket(key, (Codec)new StringCodec()).get();
            trans.setSuccessStatus();
            Long l = Long.parseLong(str);
            return l;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> T getByteCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redissonClient.getBucket(key, (Codec)new KryoCodec()).get();
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> T getCommCache(String key) {
        if (this.otherRedissClientMap.get(0) == null) {
            this.initOtherRedissonClient(0);
        }
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.otherRedissClientMap.get(0).getBucket(key).get();
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> T getCacheWithDbIndex(Integer dbIndex, String key) {
        if (this.otherRedissClientMap.get(dbIndex) == null) {
            this.initOtherRedissonClient(dbIndex);
        }
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.otherRedissClientMap.get(dbIndex).getBucket(key).get();
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putAllHashCache(String key, Map<String, T> map) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBatch batch = this.redissonClient.createBatch();
            RMapAsync rMapAsync = batch.getMap(key);
            for (Map.Entry<String, T> entry : map.entrySet()) {
                rMapAsync.fastPutAsync((Object)entry.getKey(), entry.getValue());
            }
            batch.execute();
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putAllHashCache(String key, Map<String, T> map, Long liveTimeSec) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBatch batch = this.redissonClient.createBatch();
            RMapAsync rmapAsync = batch.getMap(key);
            for (Map.Entry<String, T> entry : map.entrySet()) {
                rmapAsync.fastPutAsync((Object)entry.getKey(), entry.getValue());
            }
            rmapAsync.expireAsync(liveTimeSec.longValue(), TimeUnit.SECONDS);
            batch.execute();
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putHashCache(String key, String hashKey, T t) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RMap rmap = this.redissonClient.getMap(key);
            rmap.fastPut((Object)hashKey, t);
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> T getHashCache(String key, String hashKey) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"getHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redissonClient.getMap(key).get((Object)hashKey);
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public <T> List<T> mutiHashGet(String key, List<String> hashKeyList) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"mutiGetHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RMap rmap = this.redissonClient.getMap(key);
            ArrayList<Object> result = new ArrayList<Object>();
            for (String hashKey : hashKeyList) {
                result.add(rmap.get((Object)hashKey));
            }
            trans.setSuccessStatus();
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
        finally {
            trans.complete();
        }
    }

    public long incr(String key) {
        try {
            RAtomicLong atomicLong = this.redissonClient.getAtomicLong(key);
            return atomicLong.incrementAndGet();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public long incr(String key, int step) {
        try {
            RAtomicLong atomicLong = this.redissonClient.getAtomicLong(key);
            return atomicLong.addAndGet((long)step);
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public long decr(String key) {
        try {
            RAtomicLong atomicLong = this.redissonClient.getAtomicLong(key);
            return atomicLong.decrementAndGet();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public long decr(String key, int step) {
        try {
            RAtomicLong atomicLong = this.redissonClient.getAtomicLong(key);
            return atomicLong.addAndGet((long)(-step));
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public void expire(String key, long timeToLive) {
        try {
            RBucket bucket = this.redissonClient.getBucket(key);
            bucket.expire(timeToLive, TimeUnit.SECONDS);
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public void expire(String key, Date date) {
        try {
            RBucket bucket = this.redissonClient.getBucket(key);
            bucket.expireAt(date);
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            throw new RuntimeException("redis\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38", th);
        }
    }

    public <T> RLocalCachedMap<String, T> getLocalCacheMap(String key, Integer cacheSize, Long timeToLiveSec) {
        return this.getLocalCacheMap(key, cacheSize, timeToLiveSec, false);
    }

    public <T> RLocalCachedMap<String, T> getLocalCacheMap(String key, Integer cacheSize, Long timeToLiveSec, boolean syncOnChange) {
        LocalCachedMapOptions options = LocalCachedMapOptions.defaults().evictionPolicy(LocalCachedMapOptions.EvictionPolicy.LFU).cacheSize(cacheSize.intValue()).invalidateEntryOnChange(syncOnChange).timeToLive(timeToLiveSec.longValue(), TimeUnit.SECONDS).maxIdle(0L);
        RLocalCachedMap map = this.redissonClient.getLocalCachedMap(key, options);
        return map;
    }

    public <T> BlockingQueue<T> getReddisonQueue(String queueName) {
        return this.redissonClient.getBlockingQueue(queueName);
    }

    public boolean delCache(String key) {
        return this.redissonClient.getBucket(key).delete();
    }

    public boolean delCommCache(String key) {
        if (this.otherRedissClientMap.get(0) == null) {
            this.initOtherRedissonClient(0);
        }
        return this.otherRedissClientMap.get(0).getBucket(key).delete();
    }

    public <T> T executeScript(String scriptStr) {
        return (T)this.redissonClient.getScript().eval(RScript.Mode.READ_ONLY, scriptStr, RScript.ReturnType.VALUE);
    }

    public Future<Object> executeScriptAsync(String scriptStr) {
        RScript s = this.redissonClient.getScript();
        String sha = s.scriptLoad(scriptStr);
        return s.evalShaAsync(RScript.Mode.READ_ONLY, sha, RScript.ReturnType.VALUE, Collections.emptyList(), new Object[0]);
    }

    private <T, V> T executeNamedScript(String name, Object returnType, RScript.Mode mode, int count, Object ... args) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)("exec-lua " + name));
        Cat.logEvent((String)"luaName", (String)name);
        Cat.logEvent((String)"luaArg", (String)JSON.toJSONString((Object)args));
        RedisNamedScript namedScript = null;
        try {
            namedScript = this.redisScriptManager.getNamedScript(name);
            if (namedScript == null) {
                T t = null;
                return t;
            }
            T ret = null;
            if (returnType instanceof Class) {
                ret = namedScript.eval(this.redissonClient, (Class)returnType, mode, args);
            } else if (returnType instanceof TypeReference) {
                ret = namedScript.eval(this.redissonClient, (TypeReference)returnType, mode, args);
            }
            trans.setSuccessStatus();
            T t = ret;
            return t;
        }
        catch (RedisException ex) {
            if (ex.getMessage().indexOf("NOSCRIPT") > -1) {
                namedScript.load(this.redissonClient);
                if (count > 0) {
                    T t = this.executeNamedScript(name, returnType, mode, count - 1, args);
                    return t;
                }
                throw ex;
            }
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", (Throwable)ex);
            Cat.logError((Throwable)ex);
            trans.setStatus((Throwable)ex);
            throw ex;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            throw th;
        }
        finally {
            trans.complete();
        }
    }

    public <T> T executeNamedScript(String name, Class<T> returnType, Object ... args) {
        return this.executeNamedScript(name, (Object)returnType, RScript.Mode.READ_WRITE, 2, args);
    }

    public <T> T executeNamedScript(String name, TypeReference<T> returnType, Object ... args) {
        return this.executeNamedScript(name, (Object)returnType, RScript.Mode.READ_WRITE, 2, args);
    }

    public <T> T executeNamedScriptReadOnly(String name, Class<T> returnType, Object ... args) {
        return this.executeNamedScript(name, (Object)returnType, RScript.Mode.READ_ONLY, 2, args);
    }

    public <T> T executeNamedScriptReadOnly(String name, TypeReference<T> returnType, Object ... args) {
        return this.executeNamedScript(name, (Object)returnType, RScript.Mode.READ_ONLY, 2, args);
    }

    public void watch(String ... keys) {
        if (this.redisConnection == null) {
            String address = ((URI)this.redissonClient.getConfig().useSentinelServers().getSentinelAddresses().get(0)).getPath();
            String password = this.redissonClient.getConfig().useSentinelServers().getPassword();
            int database = this.redissonClient.getConfig().useSentinelServers().getDatabase();
            RedisClientConfig config = new RedisClientConfig();
            config.setAddress(address).setPassword(password).setDatabase(database).setClientName("redisClient");
            org.redisson.client.RedisClient redisClient = org.redisson.client.RedisClient.create((RedisClientConfig)config);
            this.redisConnection = redisClient.connect();
        }
        this.redisConnection.sync((Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.WATCH, (Object[])keys);
    }

    private void initOtherRedissonClient(int dbIndex) {
        Config oldConfig = this.redissonClient.getConfig();
        Config config = new Config(oldConfig);
        config.useSentinelServers().setDatabase(dbIndex);
        RedissonClient redissonClient = Redisson.create((Config)config);
        this.otherRedissClientMap.put(dbIndex, redissonClient);
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

