/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.lock;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedisDistributLock {
    private final Log log = LogFactory.getLog(this.getClass());
    private int defaultSingleExpireTime = 3;
    private int defaultBatchExpireTime = 6;
    private RedissonClient redissonClient;

    public boolean tryLock(String key) {
        return this.tryLock(key, 0L, null);
    }

    public boolean tryLock(String key, long timeout, TimeUnit unit) {
        boolean result = false;
        RLock lock = this.redissonClient.getLock(key);
        try {
            result = lock.tryLock(timeout, (long)this.defaultSingleExpireTime, unit);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean tryLock(String key, long timeout, long expireTime, TimeUnit unit) {
        boolean result = false;
        RLock lock = this.redissonClient.getLock(key);
        try {
            result = lock.tryLock(timeout, expireTime, unit);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean tryLock(List<String> keyList, long timeout, TimeUnit unit) {
        boolean result = false;
        RLock lock = null;
        try {
            for (String key : keyList) {
                lock = this.redissonClient.getLock(key);
                result = lock.tryLock(timeout, (long)this.defaultSingleExpireTime, unit);
                if (result) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return true;
    }

    public void lock(String key) {
        RLock lock = this.redissonClient.getLock(key);
        try {
            lock.lock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unLock(String key) {
        RLock lock = this.redissonClient.getLock(key);
        try {
            lock.unlock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unLock(List<String> keyList) {
        RLock lock = null;
        try {
            for (String key : keyList) {
                lock = this.redissonClient.getLock(key);
                lock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isLock(String key) {
        boolean result = false;
        RLock lock = this.redissonClient.getLock(key);
        try {
            result = lock.isLocked();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isHeldByCurrThread(String key) {
        boolean result = false;
        RLock lock = this.redissonClient.getLock(key);
        try {
            result = lock.isHeldByCurrentThread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getDefaultSingleExpireTime() {
        return this.defaultSingleExpireTime;
    }

    public void setDefaultSingleExpireTime(int defaultSingleExpireTime) {
        this.defaultSingleExpireTime = defaultSingleExpireTime;
    }

    public int getDefaultBatchExpireTime() {
        return this.defaultBatchExpireTime;
    }

    public void setDefaultBatchExpireTime(int defaultBatchExpireTime) {
        this.defaultBatchExpireTime = defaultBatchExpireTime;
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

