/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.converter;

import com.thebeastshop.common.enums.BooleanValue;
import com.thebeastshop.common.enums.CodeEnum;
import com.thebeastshop.common.exception.CodeEnumConvertException;
import com.thebeastshop.common.utils.EnumUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class BeanFieldConverter {
    public static Object convert(Object sourceObj, Class sourceType, Class targetType) {
        if (sourceObj == null) {
            return null;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return sourceObj;
        }
        if (Integer.class.isAssignableFrom(sourceType) && Boolean.class.isAssignableFrom(targetType)) {
            if ((Integer)sourceObj == 0) {
                return false;
            }
            return true;
        }
        if (Boolean.class.isAssignableFrom(sourceType) && Integer.class.isAssignableFrom(targetType)) {
            if (!((Boolean)sourceObj).booleanValue()) {
                return 0;
            }
            return 1;
        }
        if (sourceObj instanceof BooleanValue && (targetType.isAssignableFrom(Boolean.class) || targetType.isAssignableFrom(Boolean.TYPE))) {
            BooleanValue booleanValue = (BooleanValue)sourceObj;
            return booleanValue.toBooleanValue();
        }
        if (sourceObj instanceof CodeEnum) {
            CodeEnum codeEnum = (CodeEnum)sourceObj;
            Object code = codeEnum.getCode();
            Class<?> codeType = code.getClass();
            if (!targetType.isAssignableFrom(codeType)) {
                throw new CodeEnumConvertException(sourceType.getName() + "\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684\u6cdb\u578b\u7c7b\u578b\u53c2\u6570\uff0cCodeEnum<>\u6cdb\u578b\u53c2\u6570\u4e2d\u7684" + codeType.getName() + "\u4e0d\u80fd\u8f6c\u6362\u4e3a" + targetType.getName());
            }
            return code;
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            if (BooleanValue.class.isAssignableFrom(targetType) && (Boolean.class.isAssignableFrom(sourceType) || Boolean.TYPE.isAssignableFrom(sourceType))) {
                return EnumUtil.getByBooleanValue(targetType, (Boolean)sourceObj);
            }
            if (CodeEnum.class.isAssignableFrom(targetType)) {
                Type[] interfaces;
                for (Type type : interfaces = targetType.getGenericInterfaces()) {
                    ParameterizedType parameterizedType;
                    Class rawType;
                    if (!(type instanceof ParameterizedType) || !CodeEnum.class.isAssignableFrom(rawType = (Class)(parameterizedType = (ParameterizedType)type).getRawType())) continue;
                    Type[] argTypes = parameterizedType.getActualTypeArguments();
                    if (argTypes.length != 1) {
                        throw new CodeEnumConvertException(targetType.getName() + "\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684\u6cdb\u578b\u7c7b\u578b\u53c2\u6570");
                    }
                    Class argType = (Class)argTypes[0];
                    if (!argType.isAssignableFrom(sourceType)) {
                        throw new CodeEnumConvertException(targetType.getName() + "\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684\u6cdb\u578b\u7c7b\u578b\u53c2\u6570\uff0c " + sourceType.getName() + "\u65e0\u6cd5\u8f6c\u6362\u4e3aCodeEnum<>\u6cdb\u578b\u53c2\u6570\u4e2d\u7684" + argType.getName());
                    }
                    return EnumUtil.getByCode(targetType, sourceObj);
                }
            }
        }
        return null;
    }
}

