/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

public class RedisScriptSource {
    private String name;
    private URL url;
    private String filename;
    private String folder;
    private InputStream inputStream;
    private boolean hasRead = false;
    private String source;

    public RedisScriptSource(Resource resource) throws IOException {
        this(resource.getURL());
    }

    public RedisScriptSource(URL url) throws IOException {
        this.url = url;
        this.inputStream = url.openStream();
        this.filename = url.getFile();
        this.name = this.getScriptName(this.filename);
        this.folder = this.getFolderName(this.filename);
    }

    public void read() throws IOException {
        if (this.hasRead) {
            return;
        }
        try {
            this.source = IOUtils.toString((InputStream)this.inputStream, (String)"UTF-8");
            this.hasRead = true;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inputStream);
        }
    }

    private String getScriptName(String filename) {
        String[] segments = filename.split("/|\\\\");
        return segments[segments.length - 1];
    }

    private String getFolderName(String filename) {
        String[] parts = filename.split("!");
        if (parts.length == 2) {
            filename = parts[1];
        }
        Object[] segments = filename.split("/|\\\\");
        Object[] folderSeg = (String[])ArrayUtils.subarray((Object[])segments, (int)0, (int)(segments.length - 1));
        String folderName = StringUtils.join((Object[])folderSeg, (char)'/');
        return folderName;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFolder() {
        return this.folder;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean isHasRead() {
        return this.hasRead;
    }

    public String getSource() {
        if (!this.hasRead) {
            throw new RuntimeException("This Redis script source [" + this.name + "] has not been read!");
        }
        return this.source;
    }
}

