package com.thebeastshop.common.exception;

import com.thebeastshop.common.prop.PropConstants;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 基础异常类
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-26 11:10
 */
public class BaseServiceException extends RuntimeException {

    // 异常所在服务名
    private final String appId = PropConstants.getAppId();

    // 错误码
    private String errorCode;

    public BaseServiceException(final String errorCode) {
        super();
        this.errorCode = errorCode;
    }


    public BaseServiceException(final String errorCode, final Throwable cause) {
        this(errorCode, null, cause);
        this.errorCode = errorCode;
    }

    public BaseServiceException(final BaseErrorCode exceptionCode, final Throwable cause) {
        this(exceptionCode, exceptionCode.getErrorCode(), cause);
    }


    public BaseServiceException(final BaseErrorCode exceptionCode) {
        this(exceptionCode.getErrorCode(), exceptionCode.getMessage());
    }

    public BaseServiceException(final BaseErrorCode exceptionCode, final String msg) {
        this(exceptionCode.getErrorCode(), msg);
    }

    public BaseServiceException(final BaseErrorCode exceptionCode, final String msg, final Throwable cause) {
        this(exceptionCode.getErrorCode(), msg, cause);
    }

    public BaseServiceException(final String errorCode, final String msg) {
        super("[" + PropConstants.getAppId() + ":" + errorCode + "]" + msg);
        this.errorCode = errorCode;
    }

    public BaseServiceException(final String errorCode, final String msg, final Throwable cause) {
        super("[" + PropConstants.getAppId() + ":" + errorCode + "]" + msg, cause);
        this.errorCode = errorCode;
    }



    public String getErrorCode() {
        return errorCode;
    }

    public String getAppId() {
        return appId;
    }

/*
    private static String errorMessage(final BaseErrorCode exceptionCode, final String msg) {
        if (StringUtils.isNotEmpty(msg)) {
            return exceptionCode.getMessage() + ": " + msg;
        }
        return exceptionCode.getMessage();
    }
*/

    public Map<String, Object> getErrorData() {
        return new HashMap<>();
    }
}
