package com.thebeastshop.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author admin
 * @create 2018-07-25 17:15
 * 渠道业务线
 */
public enum ServiceLineEnum {

    MS(1,"MS"),
    HOME(2,"HOME"),
    TBH(3,"TBH"),
    LITTLE_B(4,"LittleB");

    public final Integer key;
    public final String value;

    public static final List<ServiceLineEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    ServiceLineEnum(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public Integer getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValueByKey(Integer key) {
        ServiceLineEnum serviceLineEnum = getEnumByKey(key);
        if (serviceLineEnum != null){
            return serviceLineEnum.getValue();
        }
        return "";
    }

    public static ServiceLineEnum getEnumByKey(Integer key) {
        if (key == null){
            return null;
        }
        for (ServiceLineEnum serviceLineEnum : ServiceLineEnum.values()) {
            if (serviceLineEnum.getKey().equals(key)) {
                return serviceLineEnum;
            }
        }
        return null;
    }


    @Override
    public String toString() {
        return this.getKey().toString();
    }
}
