/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.converter.BeanConverterHandlerManager;
import com.thebeastshop.common.converter.ConverterSupport;
import com.thebeastshop.common.converter.GenericBeanConverter;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ConcurrentReferenceHashMap;

public class BeanUtil {
    public static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        return ConverterSupport.matchHandlerManager(fromClass, toClass);
    }

    public static <T> T buildFrom(Object src, Class<T> clz) {
        return BeanUtil.buildFrom(src, clz, null);
    }

    public static <T> T buildFrom(Object src, Class<T> clazz, String[] ignoreProperties) {
        if (src == null) {
            return null;
        }
        Object ret = null;
        try {
            ret = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return null;
        }
        Class<?> fromClass = src.getClass();
        BeanConverterHandlerManager handlerManager = BeanUtil.matchHandlerManager(fromClass, clazz);
        String[] ignoreFields = ignoreProperties;
        if (handlerManager != null) {
            if (ignoreFields == null) {
                ignoreFields = handlerManager.getIgnoreFields();
            }
            GenericBeanConverter.copyProperties(src, ret, ignoreFields);
            handlerManager.afterCopyProperties(src, ret);
        } else {
            GenericBeanConverter.copyProperties(src, ret, ignoreFields);
        }
        return (T)ret;
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz) {
        return BeanUtil.buildListFrom(src, clz, null);
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, String[] ignoreProperties) {
        if (CollectionUtils.isEmpty(src)) {
            return Collections.emptyList();
        }
        ArrayList<T> objs = new ArrayList<T>(src.size());
        for (Object o : src) {
            T obj = BeanUtil.buildFrom(o, clz, ignoreProperties);
            objs.add(obj);
        }
        return objs;
    }

    private static <K, V> Map<K, V> newEmptyMap(Class srcClass) {
        if (ConcurrentReferenceHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentReferenceHashMap();
        }
        if (ConcurrentSkipListMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentSkipListMap();
        }
        if (ConcurrentHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentHashMap();
        }
        if (LinkedHashMap.class.isAssignableFrom(srcClass)) {
            return new LinkedHashMap();
        }
        return new HashMap();
    }

    public static <K, V> Map<K, V> buildMapFrom(Map<K, ?> src, Class<V> valueClass) {
        return BeanUtil.buildMapFrom(src, valueClass, null);
    }

    public static <K, V> Map<K, V> buildMapFrom(Map<K, ?> src, Class<V> valueClass, String[] ignoreProperties) {
        if (MapUtils.isEmpty(src)) {
            return BeanUtil.newEmptyMap(src.getClass());
        }
        Map<K, V> resultMap = BeanUtil.newEmptyMap(src.getClass());
        for (Map.Entry<K, ?> entry : src.entrySet()) {
            K key = entry.getKey();
            Object value = entry.getValue();
            V newValue = BeanUtil.buildFrom(value, valueClass, ignoreProperties);
            resultMap.put(key, newValue);
        }
        return resultMap;
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static void copyPropertiesIgnoreNull(Object src, Object target) {
        BeanUtils.copyProperties((Object)src, (Object)target, (String[])BeanUtil.getNullPropertyNames(src));
    }
}

