/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.kafka;

import com.thebeastshop.common.ByteHandler;
import java.util.List;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.concurrent.ListenableFuture;

public class KafkaProducerClient {
    private KafkaTemplate kafkaTemplate;

    public <T extends ByteHandler> boolean send(T t) {
        return this.send(this.kafkaTemplate.getDefaultTopic(), t);
    }

    public <T extends ByteHandler> boolean send(String topic, T t) {
        return this.send(topic, null, t);
    }

    public <T extends ByteHandler> void send(String topic, List<T> list) {
        for (ByteHandler t : list) {
            this.send(topic, t);
        }
    }

    public <T extends ByteHandler> boolean send(String topic, String key, T t) {
        ListenableFuture future = this.kafkaTemplate.send(topic, (Object)key, t);
        return future.isDone();
    }

    public KafkaTemplate getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    public void setKafkaTemplate(KafkaTemplate kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

