/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.kafka;

import com.thebeastshop.common.ByteHandler;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.support.Acknowledgment;

public abstract class KafkaConsumerListener<V extends ByteHandler>
implements AcknowledgingMessageListener<String, ByteBuffer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ConsumerRecord<String, ByteBuffer> record, Acknowledgment acknowledgment) {
        ByteBuffer data = (ByteBuffer)record.value();
        this.log.info("receive message, type:{}, value:{}", (Object)((ByteBuffer)record.value()).getClass().getSimpleName(), (Object)((ByteBuffer)record.value()).toString());
        try {
            String key = (String)record.key();
            Class<?> clazz = this.getClass(key);
            ByteHandler v = (ByteHandler)clazz.newInstance();
            v.mergeFrom(data);
            this.processMessage(key, v);
        }
        catch (Exception e) {
            this.log.error("\u6d88\u8d39\u8005\u7aef\u5904\u7406\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            acknowledgment.acknowledge();
        }
    }

    public Class<?> getClass(String key) {
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return clazz;
    }

    public abstract void processMessage(String var1, V var2);
}

