/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.limit;

import com.thebeastshop.common.limit.LimitFallbackEnable;
import com.thebeastshop.common.limit.LimitManager;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;

public class DubboSentinelFallbackProcessor
implements BeanPostProcessor,
PriorityOrdered,
BeanFactoryAware {
    private List<String> fallbackPackages = new LinkedList<String>();
    private static final String FALLBACK_PACKAGE_POSTFIX = ".fallback";

    public Object postProcessBeforeInitialization(Object bean, String s) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String s) throws BeansException {
        Class<?> clazz = bean.getClass();
        LimitFallbackEnable limitFallbackEnableAnn = null;
        try {
            limitFallbackEnableAnn = clazz.getAnnotation(LimitFallbackEnable.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (limitFallbackEnableAnn != null) {
            this.processServiceInterace(clazz, bean);
        }
        return bean;
    }

    private void processServiceInterace(Class clazz, Object bean) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        Class<?>[] interfaceClasses = clazz.getInterfaces();
        if (interfaceClasses == null || interfaceClasses.length == 0) {
            return;
        }
        for (Class<?> interfaceClass : interfaceClasses) {
            if (!interfaceClass.getPackage().getName().endsWith(".service")) continue;
            LimitManager.registerFallback(interfaceClass, bean);
            return;
        }
        for (Class<?> interfaceClass : interfaceClasses) {
            this.processServiceInterace(interfaceClass, bean);
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        System.out.println("xxx");
    }
}

