/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.limit;

import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallback;
import com.alibaba.csp.sentinel.adapter.dubbo.fallback.DubboFallbackRegistry;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.apollo.ApolloDataSource;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.thebeastshop.common.limit.BeastDubboFallback;
import com.thebeastshop.common.prop.PropConstants;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApploDatasourceInitFunc
implements InitFunc {
    private static final Logger logger = LoggerFactory.getLogger(ApploDatasourceInitFunc.class);
    private static final String SENTINEL_NAMESPACE = "ARC.sentinel";
    private static final String SENTINEL_RULEKEY_FLOW_RULE = "sentinel.flow.rules";
    private static final String SENTINEL_RULEKEY_DEGRADE_RULE = "sentinel.degrade.rules";
    private static final String SENTINEL_RULEKEY_PARAMFLOW_RULE = "sentinel.paramflow.rules";

    public void init() {
        Properties properties = System.getProperties();
        String env = PropConstants.getEnv(properties);
        logger.info(" [SENTINEL] init Sentinel-Apollo! ENV: " + env);
        if ("local".equals(env)) {
            return;
        }
        String metaName = env + "_meta";
        String metaUrl = PropConstants.getProperties(metaName);
        logger.info(" [SENTINEL] init Sentinel-Apollo! META URL: " + metaUrl);
        if (StringUtil.isNotEmpty((String)metaUrl)) {
            System.setProperty("apollo.meta", metaUrl);
        }
        DubboFallbackRegistry.setProviderFallback((DubboFallback)new BeastDubboFallback());
        ApolloDataSource flowRuleDataSource = new ApolloDataSource(SENTINEL_NAMESPACE, SENTINEL_RULEKEY_FLOW_RULE, "[]", (Converter)new Converter<String, List<FlowRule>>(){

            public List<FlowRule> convert(String s) {
                logger.info("[SENTINEL] Update Flow Rule: " + s);
                return (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]);
            }
        });
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        ApolloDataSource degradeRuleDataSource = new ApolloDataSource(SENTINEL_NAMESPACE, SENTINEL_RULEKEY_DEGRADE_RULE, "[]", (Converter)new Converter<String, List<DegradeRule>>(){

            public List<DegradeRule> convert(String s) {
                logger.info("[SENTINEL] Update Degrade Rule: " + s);
                return (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<DegradeRule>>(){}, (Feature[])new Feature[0]);
            }
        });
        DegradeRuleManager.register2Property((SentinelProperty)degradeRuleDataSource.getProperty());
        try {
            Class.forName("com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        ApolloDataSource paramFlowRuleDataSource = new ApolloDataSource(SENTINEL_NAMESPACE, SENTINEL_RULEKEY_PARAMFLOW_RULE, "[]", (Converter)new Converter<String, List<ParamFlowRule>>(){

            public List<ParamFlowRule> convert(String s) {
                logger.info("[SENTINEL] Update Param Flow Rule: " + s);
                return (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<ParamFlowRule>>(){}, (Feature[])new Feature[0]);
            }
        });
        ParamFlowRuleManager.register2Property((SentinelProperty)paramFlowRuleDataSource.getProperty());
    }
}

