/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.utils.Base64Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPHelper {
    public static String zipAndSerialize(String str) throws Exception {
        return Base64Utils.simpleEncode(GZIPHelper.zip(str.getBytes()));
    }

    public static String deserializeAndUnzip(String str) throws Exception {
        return new String(GZIPHelper.unzip(Base64Utils.simpleDecode(str)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(byte[] value) throws IOException {
        byte[] arg2;
        ByteArrayOutputStream output = null;
        DeflaterOutputStream zip = null;
        try {
            output = new ByteArrayOutputStream();
            zip = new GZIPOutputStream(output);
            ((GZIPOutputStream)zip).write(value, 0, value.length);
            zip.close();
            arg2 = output.toByteArray();
        }
        finally {
            if (zip != null) {
                zip.close();
            }
            if (output != null) {
                output.close();
            }
        }
        return arg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unzip(byte[] value) throws IOException {
        ByteArrayOutputStream output = null;
        ByteArrayInputStream input = null;
        GZIPInputStream zip = null;
        try {
            byte[] arg5;
            int read;
            output = new ByteArrayOutputStream();
            input = new ByteArrayInputStream(value);
            zip = new GZIPInputStream(input);
            byte[] buffer = new byte[1024];
            while ((read = zip.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
            byte[] byArray = arg5 = output.toByteArray();
            return byArray;
        }
        finally {
            if (zip != null) {
                zip.close();
            }
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }
}

