/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.prop;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.google.common.collect.Lists;
import com.thebeastshop.common.prop.ServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public class PropConstants
extends PropertySourcesPlaceholderConfigurer {
    private static final Logger log = LoggerFactory.getLogger(PropConstants.class);
    private static final String ENV_KEY = "env";
    private static final String APP_ID = "app.id";
    private static final String APOLLO_CLUSTER = "apollo.cluster";
    private static final String NAMESPACES_KEY = "app.namespaces";
    private static final String NAMESPACE_APPLICATION = "application";
    private static final String ENV_LOCAL = "local";
    private static final String ENV_TEST = "test";
    private static final String ENV_PRE = "pre";
    private static final String ENV_PROD = "prod";
    private static final String APOLLO_FAT = "fat";
    private static final String APOLLO_UAT = "uat";
    private static final String APOLLO_PRO = "pro";
    private static PropConstants propConstants;
    private Properties props = new Properties();
    private List<String> propList;

    public PropConstants() {
        log.info("init PropConstants");
    }

    public static String getMetaAppProperty(String name) {
        return ServiceUtil.getAppProperty(name);
    }

    public static String getAppId() {
        return ServiceUtil.getAppId();
    }

    public static String getProperties(String key) {
        if (propConstants == null) {
            return null;
        }
        return propConstants.getProperty(key);
    }

    public static String getProperties(String key, String defaultValue) {
        if (propConstants == null) {
            return null;
        }
        return propConstants.getProperty(key, defaultValue);
    }

    public static Object setProperties(String key, String value) {
        if (propConstants == null) {
            return null;
        }
        return propConstants.setProperty(key, value);
    }

    private static String getPrioritizedProperty(Properties properties, String key) {
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value) && StringUtils.isEmpty((CharSequence)(value = properties.getProperty(key))) && StringUtils.isEmpty((CharSequence)(value = ServiceUtil.getServerSideAppProperty(key))) && StringUtils.isEmpty((CharSequence)(value = ServiceUtil.getServerSideProperty(key))) && StringUtils.isEmpty((CharSequence)(value = PropConstants.getMetaAppProperty(key)))) {
            value = System.getenv(key);
        }
        return value;
    }

    public static String getEnv(Properties properties) {
        String env = PropConstants.getPrioritizedProperty(properties, ENV_KEY);
        if (StringUtils.isEmpty((CharSequence)env)) {
            return ENV_LOCAL;
        }
        return PropConstants.getApolloEnvName(env);
    }

    public static String getApolloCluster(Properties properties) {
        String cluster = PropConstants.getPrioritizedProperty(properties, APOLLO_CLUSTER);
        if (StringUtils.isNotBlank((CharSequence)cluster)) {
            return cluster.trim();
        }
        return null;
    }

    public List<String> getNamespaces(ConfigMeta meta, Properties properties) {
        String namespaces = PropConstants.getPrioritizedProperty(properties, NAMESPACES_KEY);
        ArrayList<String> namespacesList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)namespaces)) {
            return namespacesList;
        }
        meta.namespaces = namespaces.trim();
        this.props.put(NAMESPACES_KEY, namespaces);
        if (StringUtils.isNotEmpty((CharSequence)namespaces)) {
            String[] nsArr;
            for (String ns : nsArr = namespaces.split(",")) {
                if (NAMESPACE_APPLICATION.equals(ns = ns.trim())) continue;
                namespacesList.add(ns);
            }
        }
        meta.namespaceList = namespacesList;
        return namespacesList;
    }

    private ConfigMeta getConfigMeta(Properties properties) {
        String metaUrl;
        String env = PropConstants.getEnv(properties);
        if (ENV_LOCAL.equals(env)) {
            return null;
        }
        String key = env + "_meta";
        ConfigMeta meta = new ConfigMeta();
        meta.metaName = key;
        this.getNamespaces(meta, properties);
        meta.metaUrl = metaUrl = PropConstants.getPrioritizedProperty(properties, key);
        return meta;
    }

    protected Properties mergeProperties() throws IOException {
        String configLogEnable;
        Properties properties = super.mergeProperties();
        log.info("---- start process properties ---");
        this.props = new Properties();
        String env = PropConstants.getEnv(properties);
        this.setActiveProperty(ENV_KEY, env);
        String appId = PropConstants.getAppId();
        String cluster = PropConstants.getApolloCluster(properties);
        this.setActiveProperty(APP_ID, appId);
        if (StringUtils.isNotEmpty((CharSequence)cluster)) {
            this.setActiveProperty(APOLLO_CLUSTER, cluster);
        }
        ConfigMeta meta = this.readConfig(env, properties);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@****************************************************************************************@\n");
        stringBuilder.append("@                               * THE BEAST CONFIGURATION *                              @\n");
        stringBuilder.append("@****************************************************************************************@\n");
        stringBuilder.append("\n");
        stringBuilder.append("------------------------------------ Service META INFO -----------------------------------\n");
        stringBuilder.append("|\n");
        stringBuilder.append("|   Environment : " + this.getPrintableEnvName(env) + "\n");
        stringBuilder.append("|   App ID : " + appId + "\n");
        if (StringUtils.isNotEmpty((CharSequence)cluster)) {
            stringBuilder.append("|   Apollo Cluster : " + cluster + "\n");
        }
        if (meta != null) {
            if (meta.metaName != null) {
                stringBuilder.append("|   Meta Name : " + meta.metaName + "\n");
            }
            if (meta.metaUrl != null) {
                stringBuilder.append("|   Meta URL : " + meta.metaUrl + "\n");
            }
            if (meta.namespaceList != null) {
                stringBuilder.append("|   Namespaces : " + StringUtils.join(meta.namespaceList, (String)", ") + "\n");
            }
        }
        if ((configLogEnable = System.getProperty("config.log.enable")) == null || !"false".equals(configLogEnable.toLowerCase())) {
            this.printAllProperties(meta, stringBuilder);
        }
        stringBuilder.append("|\n");
        stringBuilder.append("@****************************************************************************************@\n");
        log.info("init properties:\n\n" + stringBuilder.toString());
        propConstants = this;
        return this.props;
    }

    private void setActiveProperty(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.props.setProperty(name, value);
        System.setProperty(name, value);
    }

    private void printAllProperties(ConfigMeta meta, StringBuilder stringBuilder) {
        Properties cache = new Properties();
        for (String key : meta.properties.keySet()) {
            Properties properties = meta.properties.get(key);
            this.printProperties(properties, "Namespace: " + key, stringBuilder, cache);
        }
        Iterator<Map.Entry<Object, Object>> pIt = this.props.entrySet().iterator();
        Properties otherProps = new Properties();
        while (pIt.hasNext()) {
            Map.Entry<Object, Object> entry = pIt.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (cache.containsKey(key)) continue;
            otherProps.put(key, value);
        }
        this.printProperties(otherProps, "Other Properties", stringBuilder, null);
    }

    private void printProperties(Properties properties, String title, StringBuilder stringBuilder, Properties cache) {
        if (properties.size() == 0) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
        stringBuilder.append("|\n");
        stringBuilder.append("------------------------------------ " + title + " -----------------------------------\n");
        stringBuilder.append("|\n");
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (cache != null) {
                cache.put(key, value);
            }
            stringBuilder.append("|   " + key + " = " + value + "\n");
        }
    }

    private static String getApolloEnvName(String env) {
        if (ENV_TEST.equals(env)) {
            return APOLLO_FAT;
        }
        if (ENV_PRE.equals(env)) {
            return APOLLO_UAT;
        }
        if (ENV_PROD.equals(env)) {
            return APOLLO_PRO;
        }
        return env;
    }

    private String getPrintableEnvName(String env) {
        String upEnv = env.toUpperCase();
        if (APOLLO_FAT.equals(env)) {
            return "TEST (FAT)";
        }
        if (APOLLO_UAT.equals(env)) {
            return "PRE (UAT)";
        }
        if (APOLLO_PRO.equals(env)) {
            return "PROD (PRO)";
        }
        return upEnv;
    }

    private ConfigMeta readConfig(String env, Properties properties) {
        ConfigMeta meta = null;
        meta = ENV_LOCAL.equals(env) ? this.readFromLocal(properties) : this.readFromApollo(properties);
        return meta;
    }

    private ConfigMeta readFromLocal(Properties properties) {
        ConfigMeta meta = new ConfigMeta();
        meta.metaName = "local config";
        meta.namespaces = "Local Config";
        meta.namespaceList = Lists.newArrayList((Object[])new String[]{"Local Config"});
        Properties nsProps = new Properties();
        meta.properties.put(meta.namespaces, nsProps);
        for (Map.Entry<Object, Object> propIt : properties.entrySet()) {
            if (this.props.containsKey(propIt.getKey())) continue;
            String key = propIt.getKey().toString();
            Object value = propIt.getValue();
            this.props.put(key, value);
            nsProps.put(key, value);
        }
        return meta;
    }

    private ConfigMeta readFromApollo(Properties properties) {
        ConfigMeta meta = this.getConfigMeta(properties);
        if (meta != null) {
            this.props.put(meta.metaName, meta.metaUrl);
            System.setProperty(meta.metaName, meta.metaUrl);
        }
        this.readApolloConfig(NAMESPACE_APPLICATION, meta, ConfigService.getAppConfig());
        if (meta.namespaceList != null) {
            for (String namespace : meta.namespaceList) {
                this.readApolloConfig(namespace, meta, ConfigService.getConfig((String)namespace));
            }
        }
        return meta;
    }

    private void readApolloConfig(String namespace, ConfigMeta meta, Config config) {
        Properties properties = meta.properties.get(namespace);
        if (properties == null) {
            properties = new Properties();
            meta.properties.put(namespace, properties);
        }
        Set names = config.getPropertyNames();
        for (String name : names) {
            if (this.props.containsKey(name)) continue;
            String value = config.getProperty(name, null);
            this.props.setProperty(name, value);
            properties.setProperty(name, value);
        }
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        if (key == null || value == null) {
            return null;
        }
        return this.props.setProperty(key, value);
    }

    public static Properties getPropertiesObj() {
        return PropConstants.propConstants.props;
    }

    private static class ConfigMeta {
        public String metaName;
        public String metaUrl;
        public String namespaces;
        public List<String> namespaceList;
        public Map<String, Properties> properties = new LinkedHashMap<String, Properties>();
        public Properties otherProperties = new Properties();

        private ConfigMeta() {
        }
    }
}

