/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.kafka;

import com.alibaba.fastjson.JSON;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaProducerClient {
    private KafkaTemplate kafkaTemplate;
    private ExecutorService threadPool = Executors.newFixedThreadPool(20);

    public <T> void send(T t) {
        this.send(this.kafkaTemplate.getDefaultTopic(), t);
    }

    public <T> void send(String topic, T t) {
        this.send(topic, null, t);
    }

    public <T> void send(final String topic, final String key, final T t) {
        this.threadPool.submit(new Thread(){

            @Override
            public void run() {
                KafkaProducerClient.this.kafkaTemplate.send(topic, (Object)key, (Object)JSON.toJSONString((Object)t));
            }
        });
    }

    public KafkaTemplate getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    public void setKafkaTemplate(KafkaTemplate kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

