/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.prop;

import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.google.common.collect.Lists;
import com.thebeastshop.common.prop.PropChange;
import com.thebeastshop.common.prop.PropChangeEvent;
import com.thebeastshop.common.prop.PropChangeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApolloPropChangeEvent
implements PropChangeEvent {
    private ConfigChangeEvent event;
    private Map<String, PropChange> changeMap = new HashMap<String, PropChange>();

    public ApolloPropChangeEvent(ConfigChangeEvent event) {
        this.event = event;
    }

    @Override
    public String getNamespace() {
        return this.event.getNamespace();
    }

    @Override
    public List<String> getPropNames() {
        return Lists.newArrayList((Iterable)this.event.changedKeys());
    }

    @Override
    public PropChange getChange(String propName) {
        PropChange propChange = this.changeMap.get(propName);
        if (propChange != null) {
            return propChange;
        }
        ConfigChange configChange = this.event.getChange(propName);
        if (configChange == null) {
            return null;
        }
        PropertyChangeType changeType = configChange.getChangeType();
        String namespace = configChange.getNamespace();
        String newValue = configChange.getNewValue();
        String oldValue = configChange.getOldValue();
        String name = configChange.getPropertyName();
        PropChangeType propChangeType = PropChangeType.valueOf(changeType.name());
        propChange = new PropChange(propChangeType, namespace, name, newValue, oldValue);
        this.changeMap.put(propName, propChange);
        return propChange;
    }
}

