package com.thebeastshop.common.redis;

import java.util.HashMap;
import java.util.Map;

/**
 * Redis脚本管理器
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-08-09 15:08
 */
public class RedisScriptManager {

    private final static RedisScriptManager instance = new RedisScriptManager();

    private Map<String, RedisNamedScript> namedScriptMap = new HashMap<>();


    public static RedisScriptManager scriptManager() {
        return instance;
    }

    public RedisScriptManager() {
    }

    /**
     * 根据名称获得脚本对象
     * @param name
     * @return
     */
    public RedisNamedScript getNamedScript(String name) {
        return namedScriptMap.get(name);
    }

    /**
     * 添加一个命名脚本对象
     * @param namedScript
     */
    public void addNamedScript(RedisNamedScript namedScript) {
        namedScriptMap.put(namedScript.getName(), namedScript);
    }


}
