package com.thebeastshop.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AccessWayEnum implements CodeEnum<Integer> {
	UNKNOWN(0, "未知"), 
	PC(1, "PC"),
	APP(2, "APP"),
	WAP(3, "WAP"),
	OFFLINE(4, "普通门店"),
	LITTLE_B(5, "Little B门店");

	private Integer code;
	private String name;

	public static final List<AccessWayEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	AccessWayEnum(Integer code,String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static AccessWayEnum getEnumByCode(Integer code) {
		for (AccessWayEnum e : AccessWayEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
