/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.exception;

import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.common.prop.PropConstants;
import java.util.HashMap;
import java.util.Map;

public class BaseServiceException
extends RuntimeException {
    private final String appId = PropConstants.getAppId();
    private String errorCode;

    public BaseServiceException(String errorCode) {
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public BaseServiceException(BaseErrorCode exceptionCode) {
        this(exceptionCode.getErrorCode(), exceptionCode.getMessage());
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg) {
        this(exceptionCode.getErrorCode(), msg);
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg, Throwable cause) {
        this(exceptionCode.getErrorCode(), msg, cause);
    }

    public BaseServiceException(String errorCode, String msg) {
        super("[" + PropConstants.getAppId() + ":" + errorCode + "]" + msg);
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, String msg, Throwable cause) {
        super("[" + PropConstants.getAppId() + ":" + errorCode + "]" + msg);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getAppId() {
        return this.appId;
    }

    public Map<String, Object> getErrorData() {
        return new HashMap<String, Object>();
    }
}

