/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.cat;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.thebeastshop.common.cat.RestCatContext;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.lang.StringUtils;

public class RestCat {
    public static final String HEADER_ROOT = "_cat_root_message_id";
    public static final String HEADER_PARENT = "_cat_parent_message_id";
    public static final String HEADER_CHILD = "_cat_child_message_id";
    public static final String CAT_ROOT = "_catRootMessageId";
    public static final String CAT_PARENT = "_catParentMessageId";
    public static final String CAT_CHILD = "_catChildMessageId";
    private static final String APPLICATION_KEY = "_application";
    private static final String HTTP_CALL_SERVER_APP = "HttpServer.app";
    public static final String HTTP_CALL_SERVER_CLIENT = "HttpServer.client";
    private static final String CAT_TYPE_HTTP_CALL = "HttpCall";
    private static final String CAT_TYPE_HTTP_CALL_APP = "HttpCall.app";
    private static final String CAT_TYPE_HTTP_CALL_SERVER = "HttpCall.server";
    private static final String CAT_TYPE_HTTP_CALL_PORT = "HttpCall.port";
    private static final ThreadLocal<Cat.Context> CAT_CONTEXT = new ThreadLocal();

    public static Transaction newClientTransaction(String name) {
        Transaction transaction = Cat.newTransaction((String)CAT_TYPE_HTTP_CALL, (String)name);
        return transaction;
    }

    public static void createClientCross(String host, String port, Transaction transaction, String serverAppId) {
        Event crossAppEvent = Cat.newEvent((String)CAT_TYPE_HTTP_CALL_APP, (String)serverAppId);
        Event crossServerEvent = Cat.newEvent((String)CAT_TYPE_HTTP_CALL_SERVER, (String)host);
        Event crossPortEvent = Cat.newEvent((String)CAT_TYPE_HTTP_CALL_PORT, (String)port);
        crossAppEvent.setStatus("0");
        crossServerEvent.setStatus("0");
        crossPortEvent.setStatus("0");
        RestCat.completeEvent(crossAppEvent);
        RestCat.completeEvent(crossPortEvent);
        RestCat.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossAppEvent);
        transaction.addChild((Message)crossPortEvent);
        transaction.addChild((Message)crossServerEvent);
    }

    public static void createServerCross(HttpServletRequest request, Transaction transaction) {
        String consumerAppName = request.getHeader(APPLICATION_KEY);
        if (StringUtils.isEmpty((String)consumerAppName)) {
            return;
        }
        Event crossAppEvent = Cat.newEvent((String)HTTP_CALL_SERVER_APP, (String)consumerAppName);
        Event crossServerEvent = Cat.newEvent((String)HTTP_CALL_SERVER_CLIENT, (String)request.getRemoteHost());
        crossAppEvent.setStatus("0");
        crossServerEvent.setStatus("0");
        RestCat.completeEvent(crossAppEvent);
        RestCat.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossAppEvent);
        transaction.addChild((Message)crossServerEvent);
    }

    private static void completeEvent(Event event) {
        AbstractMessage message = (AbstractMessage)event;
        message.setCompleted(true);
    }

    public static void setClientHeader(HttpMethodBase httpMethod, Cat.Context context) {
        httpMethod.addRequestHeader(HEADER_ROOT, context.getProperty(CAT_ROOT));
        httpMethod.addRequestHeader(HEADER_CHILD, context.getProperty(CAT_CHILD));
        httpMethod.addRequestHeader(HEADER_PARENT, context.getProperty(CAT_PARENT));
    }

    public static Cat.Context getServerSideContext(HttpServletRequest request) {
        Cat.Context context = CAT_CONTEXT.get();
        if (context == null) {
            context = RestCat.initServerSideContext(request);
            CAT_CONTEXT.set(context);
        }
        return context;
    }

    public static void removeContext() {
        CAT_CONTEXT.remove();
    }

    public static Cat.Context getClientSideContext() {
        Cat.Context context = CAT_CONTEXT.get();
        if (context == null) {
            context = new RestCatContext();
            CAT_CONTEXT.set(context);
        }
        return context;
    }

    private static Cat.Context initServerSideContext(HttpServletRequest request) {
        RestCatContext context = new RestCatContext();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null && headerNames.hasMoreElements()) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                if (HEADER_CHILD.equals(headerName)) {
                    context.addProperty(CAT_CHILD, headerValue);
                    continue;
                }
                if (HEADER_ROOT.equals(headerName)) {
                    context.addProperty(CAT_ROOT, headerValue);
                    continue;
                }
                if (!HEADER_PARENT.equals(headerName)) continue;
                context.addProperty(CAT_PARENT, headerValue);
            }
        }
        return context;
    }
}

