/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.fileupload;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.thebeastshop.common.enums.FileTypeEnum;
import com.thebeastshop.common.fileupload.FileUploadResp;
import com.thebeastshop.common.utils.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BASE_PATH = "file/";
    private OSSClient ossClient;
    private String ossEndPoint;
    private String ossAccessId;
    private String ossAccessKey;
    private String ossBucketName;

    private String getKey(String fileUrl) {
        return fileUrl.replace("http://img.thebeastshop.com/", "");
    }

    private String buildExtraPath(String extraPath) {
        if (StringUtils.isNotBlank((String)extraPath)) {
            extraPath = extraPath.indexOf("/") == 0 ? extraPath.substring(1) : extraPath;
            extraPath = extraPath + (extraPath.lastIndexOf("/") == -1 ? "/" : "");
        } else {
            extraPath = "";
        }
        return extraPath;
    }

    private OSSClient getOssClient() {
        if (this.ossClient == null) {
            this.ossClient = new OSSClient(this.ossEndPoint, this.ossAccessId, this.ossAccessKey);
        }
        return this.ossClient;
    }

    public String getOssEndPoint() {
        return this.ossEndPoint;
    }

    public void setOssEndPoint(String ossEndPoint) {
        this.ossEndPoint = ossEndPoint;
    }

    public String getOssAccessId() {
        return this.ossAccessId;
    }

    public void setOssAccessId(String ossAccessId) {
        this.ossAccessId = ossAccessId;
    }

    public String getOssAccessKey() {
        return this.ossAccessKey;
    }

    public void setOssAccessKey(String ossAccessKey) {
        this.ossAccessKey = ossAccessKey;
    }

    public String getOssBucketName() {
        return this.ossBucketName;
    }

    public void setOssBucketName(String ossBucketName) {
        this.ossBucketName = ossBucketName;
    }

    public FileUploadResp uploadFile(String localFilePath, String extraPath) {
        File file = new File(localFilePath);
        return this.uploadFile(file, extraPath);
    }

    public FileUploadResp uploadFile(File file, String extraPath) {
        FileUploadResp info = null;
        try {
            info = this.uploadFile(new FileInputStream(file), extraPath);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath) {
        FileUploadResp info = null;
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            inputStream = new ByteArrayInputStream(baos.toByteArray());
            ByteArrayInputStream tempInputStream = new ByteArrayInputStream(baos.toByteArray());
            FileTypeEnum fileType = FileUtil.getFileType(tempInputStream);
            if (fileType == null) {
                throw new RuntimeException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301");
            }
            String fileName = BASE_PATH + this.buildExtraPath(extraPath) + UUID.randomUUID().toString().replace("-", "") + "." + fileType.getName();
            this.getOssClient().putObject(this.ossBucketName, fileName, inputStream);
            info = new FileUploadResp(inputStream, "http://img.thebeastshop.com/" + fileName);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public List<FileUploadResp> listFiles(String extraPath) {
        LinkedList<FileUploadResp> list = null;
        try {
            ObjectListing listing = this.getOssClient().listObjects(this.ossBucketName, BASE_PATH + this.buildExtraPath(extraPath));
            list = new LinkedList<FileUploadResp>();
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                list.add(this.getFile("http://img.thebeastshop.com/" + objectSummary.getKey()));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5f02\u5e38: {}", (Throwable)e);
        }
        return list;
    }

    public FileUploadResp getFile(String fileUrl) {
        FileUploadResp info = null;
        try {
            OSSObject ossObject = this.getOssClient().getObject(this.ossBucketName, this.getKey(fileUrl));
            info = new FileUploadResp(ossObject.getObjectContent(), fileUrl);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public void deleteFile(String fileUrl) {
        try {
            String key = this.getKey(fileUrl);
            this.getOssClient().deleteObject(this.ossBucketName, key);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
    }
}

