/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RBucket;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RedissonClient redissonClient;

    public boolean hasKey(String key) {
        return this.redissonClient.getBucket(key).isExists();
    }

    public <T> List<T> mutiGet(List<String> keys) {
        return new ArrayList(this.redissonClient.getBuckets().get(keys.toArray(new String[keys.size()])).values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putCache(String key, T t, Long timeOut, TimeUnit unit) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"set");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RBucket bucket = this.redissonClient.getBucket(key);
            if (timeOut == null) {
                bucket.set(t);
            } else {
                bucket.set(t, timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
        }
        finally {
            trans.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redissonClient.getBucket(key).get();
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            T t = null;
            return t;
        }
        finally {
            trans.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putHashCache(String key, Map<String, T> map, Long timeOut, TimeUnit unit) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RMap rmap = this.redissonClient.getMap(key);
            rmap.putAll(map);
            if (timeOut != null) {
                rmap.expire(timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
        }
        finally {
            trans.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putHashCache(String key, String hashKey, T t, Long timeOut, TimeUnit unit) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            RMap rmap = this.redissonClient.getMap(key);
            rmap.fastPut((Object)hashKey, t);
            if (timeOut != null) {
                rmap.expire(timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
        }
        finally {
            trans.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getHashCache(String key, String hashKey) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"getHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redissonClient.getMap(key).get((Object)hashKey);
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            T t = null;
            return t;
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putCache(String key, T t, Long timeOut) {
        this.putCache(key, t, timeOut, TimeUnit.SECONDS);
    }

    public <T> void putCache(String key, T t) {
        this.putCache(key, t, null, null);
    }

    public <T> void putHashCache(String key, String hashKey, T t) {
        this.putHashCache(key, hashKey, t, null, null);
    }

    public <T> RLocalCachedMap<String, T> getLocalCacheMap(String key, Integer cacheSize, Long timeToLiveSec) {
        return this.getLocalCacheMap(key, cacheSize, timeToLiveSec, false);
    }

    public <T> RLocalCachedMap<String, T> getLocalCacheMap(String key, Integer cacheSize, Long timeToLiveSec, boolean syncOnChange) {
        LocalCachedMapOptions options = LocalCachedMapOptions.defaults().evictionPolicy(LocalCachedMapOptions.EvictionPolicy.LFU).cacheSize(cacheSize.intValue()).invalidateEntryOnChange(syncOnChange).timeToLive(timeToLiveSec.longValue(), TimeUnit.SECONDS).maxIdle(0L);
        RLocalCachedMap map = this.redissonClient.getLocalCachedMap(key, options);
        return map;
    }

    public <T> BlockingQueue<T> getReddisonQueue(String queueName, boolean fair) {
        if (fair) {
            return this.redissonClient.getBlockingQueue(queueName);
        }
        return this.redissonClient.getBlockingFairQueue(queueName);
    }

    public boolean delCache(String key) {
        return this.redissonClient.getBucket(key).delete();
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

