/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.prop;

import com.thebeastshop.common.prop.ServiceUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PropConstants
extends PropertyPlaceholderConfigurer {
    private static final Logger log = LoggerFactory.getLogger(PropConstants.class);
    private static PropConstants propConstants;
    private Properties props = new Properties();
    private List<String> propList;

    public static String getServiceName() {
        return ServiceUtil.getServiceName();
    }

    public static String getServiceCode() {
        return ServiceUtil.getServiceCode();
    }

    public static String getProperties(String key) {
        if (propConstants == null) {
            return null;
        }
        return propConstants.getProperty(key);
    }

    public static String getProperties(String key, String defaultValue) {
        if (propConstants == null) {
            return null;
        }
        return propConstants.getProperty(key, defaultValue);
    }

    public Object setProperties(String key, String value) {
        if (propConstants == null) {
            return null;
        }
        return propConstants.setProperty(key, value);
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.props = props;
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        Map.Entry<Object, Object> entry = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("*********************start print properties***********************\n");
        stringBuilder.append("------------------------ Service META INFO -----------------------\n");
        stringBuilder.append("Service Name: " + PropConstants.getServiceName() + "\n");
        stringBuilder.append("Service Code: " + PropConstants.getServiceCode() + "\n");
        stringBuilder.append("------------------------ Normal Properties -----------------------\n");
        while (it.hasNext()) {
            entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            stringBuilder.append(key + " : " + value + "\n");
        }
        stringBuilder.append("*********************end print properties***********************\n\n");
        log.info("init properties:\n\n" + stringBuilder.toString());
        propConstants = this;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.props.setProperty(key, value);
    }
}

