/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.prop;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtil.class);
    private static Properties props;
    private static final String serviceName;
    private static final String serviceCode;
    private static final String servicePrefix;

    ServiceUtil() {
    }

    private static void initProperties() {
        String file = "/META-INF/service.properties";
        URL fileURL = ServiceUtil.class.getResource(file);
        props = new Properties();
        if (fileURL != null) {
            try {
                props.load(ServiceUtil.class.getResourceAsStream(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getServiceName() {
        return serviceName;
    }

    public static String getServiceCode() {
        return serviceCode;
    }

    public static String getServiceProperty(String name) {
        return props.getProperty(name);
    }

    static {
        ServiceUtil.initProperties();
        serviceName = ServiceUtil.getServiceProperty("service.name");
        serviceCode = ServiceUtil.getServiceProperty("service.code");
        servicePrefix = ServiceUtil.getServiceProperty("service.prefix");
    }
}

