/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.enums;

import com.thebeastshop.common.enums.RegisterSourceEnum;

public enum AccessWayEnum {
    UNKNOWN(0, "\u672a\u77e5"),
    PC(1, "PC"){

        @Override
        public RegisterSourceEnum getRegisterSource() {
            return RegisterSourceEnum.PC;
        }
    }
    ,
    APP(2, "APP"){

        @Override
        public RegisterSourceEnum getRegisterSource() {
            return RegisterSourceEnum.APP;
        }
    }
    ,
    WAP(3, "WAP"){

        @Override
        public RegisterSourceEnum getRegisterSource() {
            return RegisterSourceEnum.PC;
        }
    }
    ,
    OFFLINE(4, "\u7ebf\u4e0b\u95e8\u5e97"){

        @Override
        public RegisterSourceEnum getRegisterSource() {
            return RegisterSourceEnum.SHOP;
        }
    };

    private Integer code;
    private String name;

    private AccessWayEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public RegisterSourceEnum getRegisterSource() {
        return RegisterSourceEnum.UNKNOWN;
    }

    public static AccessWayEnum getEnumByCode(Integer code) {
        for (AccessWayEnum e : AccessWayEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        return this.getCode().toString();
    }
}

