/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common;

import com.thebeastshop.common.BaseDomain;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractBaseDomain<VO, PO>
implements BaseDomain<VO, PO> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<VO> voClass = this.getGenericClazz(0);
    private final Class<PO> moClass = this.getGenericClazz(1);

    private <T> Class<T> getGenericClazz(int index) {
        Type superClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)superClass).getActualTypeArguments()[index];
        if (type instanceof TypeVariable) {
            return (Class)((TypeVariable)type).getBounds()[0];
        }
        return (Class)type;
    }

    protected VO buildFromPO(PO record, Class<VO> voClass) {
        if (record == null) {
            return null;
        }
        VO vo = null;
        try {
            vo = voClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (vo == null) {
            return null;
        }
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    protected PO buildFromVO(VO vo, Class<PO> moClass) {
        if (vo == null) {
            return null;
        }
        PO record = null;
        try {
            record = moClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (record == null) {
            return null;
        }
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public VO buildFromPO(PO record) {
        return this.buildFromPO(record, this.voClass);
    }

    @Override
    public PO buildFromVO(VO vo) {
        return this.buildFromVO(vo, this.moClass);
    }

    @Override
    public List<PO> buildFromVOList(List<VO> voList) {
        ArrayList<PO> results = new ArrayList<PO>();
        for (VO vo : voList) {
            results.add(this.buildFromVO(vo));
        }
        return results;
    }

    @Override
    public List<VO> buildFromPOList(List<PO> poList) {
        ArrayList<VO> results = new ArrayList<VO>();
        for (PO po : poList) {
            results.add(this.buildFromPO(po));
        }
        return results;
    }
}

