package com.thebeastshop.common.sentinel.limit;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;

import java.util.LinkedList;
import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-11-20 18:04
 */
public class DubboSentinelFallbackProcessor implements BeanPostProcessor, PriorityOrdered, BeanFactoryAware {

    private List<String> fallbackPackages = new LinkedList<>();

    private final static String FALLBACK_PACKAGE_POSTFIX = ".fallback";

    @Override
    public Object postProcessBeforeInitialization(Object bean, String s) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String s) throws BeansException {
        Class clazz = bean.getClass();
        LimitFallbackEnable limitFallbackEnableAnn = null;
        try {
            limitFallbackEnableAnn = (LimitFallbackEnable) clazz.getAnnotation(LimitFallbackEnable.class);
        } catch (Throwable th) {
        }
        if (limitFallbackEnableAnn != null) {
            processServiceInterace(clazz, bean);
        }
        return bean;
    }


    private void processServiceInterace(Class clazz, Object bean) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        Class[] interfaceClasses = clazz.getInterfaces();
        if (interfaceClasses == null || interfaceClasses.length == 0) {
            return;
        }
        for (Class interfaceClass : interfaceClasses) {
            if (interfaceClass.getPackage().getName().endsWith(".service")) {
                LimitManager.registerFallback(interfaceClass, bean);
                return;
            }
        }
        for (Class interfaceClass : interfaceClasses) {
            processServiceInterace(interfaceClass, bean);
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE - 1;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        System.out.println("xxx");
    }
}
