/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.commdata.vo.dict;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class TreeDictionary
implements Serializable {
    public String type;
    public List<Node> children;

    public List<Node> getChildren() {
        return this.children;
    }

    public void setChildren(List<Node> children) {
        this.children = children;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static String getFullName(TreeDictionary tree, String code) {
        Stack<Node> path = TreeDictionary.queryPath(tree, code);
        if (path.size() == 0) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        while (!path.empty()) {
            Node node = path.pop();
            nameList.add(node.getName());
        }
        ArrayList buff = new ArrayList();
        for (int i = nameList.size() - 1; i >= 0; --i) {
            buff.add(nameList.get(i));
        }
        return String.join((CharSequence)"/", buff);
    }

    public static Stack<Node> queryPath(TreeDictionary tree, String code) {
        Stack<Node> path = new Stack<Node>();
        if (code == null || code.trim().length() == 0) {
            return path;
        }
        if (tree.getChildren() == null || tree.getChildren().size() == 0) {
            return path;
        }
        for (Node node : tree.getChildren()) {
            Node target = TreeDictionary.query(node, code, path);
            if (target == null) continue;
            return path;
        }
        return path;
    }

    public static Node query(Node node, String code, Stack<Node> path) {
        path.push(node);
        if (code.equals(node.getCode())) {
            return node;
        }
        if (node.getChildren() != null) {
            for (Node child : node.getChildren()) {
                Node target = TreeDictionary.query(child, code, path);
                if (target == null) continue;
                return target;
            }
        }
        path.pop();
        return null;
    }

    public static class Node
    implements Serializable {
        private String type;
        private String name;
        private String fullName;
        private String value;
        private String code;
        private Integer sortOrder;
        private String parentCode;
        private Integer status;
        private Integer leaf;
        private String config;
        private List<Node> children;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public Integer getSortOrder() {
            return this.sortOrder;
        }

        public void setSortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
        }

        public String getParentCode() {
            return this.parentCode;
        }

        public void setParentCode(String parentCode) {
            this.parentCode = parentCode;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getLeaf() {
            return this.leaf;
        }

        public void setLeaf(Integer leaf) {
            this.leaf = leaf;
        }

        public String getConfig() {
            return this.config;
        }

        public void setConfig(String config) {
            this.config = config;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public void setChildren(List<Node> children) {
            this.children = children;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }
    }
}

