package com.thebeastshop.cart.model.gift;

import com.thebeastshop.cart.model.ScBrand;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 赠品商品信息
 * @author feiLong.gao
 * @date 2019/12/25
 */
public class ScGiftProductVO extends BaseDO {

    private static final long serialVersionUID = -908734718912017139L;
    private String productCode;             // 商品Code
    private String productName;              // 商品名字
    private String featureImage;             // URL 商品列表图，如果列表图取不到，则使用第一张详情图
    private ScBrand brand = new ScBrand();      //品牌
    private Boolean hasVariants = Boolean.FALSE;   // 是否多规格
    private Integer maximum;                // 最大可选件数
    private Integer minAmount =1;           // 最小购买数，每件赠品，对应spv数量
    private Integer left;                   // 库存数：剩余赠品数和实际商品数，取最小值
    private Boolean owned = false;
    private Boolean soldOut;                // 是否售罄，售罄标识已赠完
    private List<ScGiftSpvVO> spvs;          // 赠品商品Spv信息列表

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getFeatureImage() {
        return featureImage;
    }

    public void setFeatureImage(String featureImage) {
        this.featureImage = featureImage;
    }

    public ScBrand getBrand() {
        return brand;
    }

    public void setBrand(ScBrand brand) {
        this.brand = brand;
    }

    public Boolean getHasVariants() {
        return hasVariants;
    }

    public void setHasVariants(Boolean hasVariants) {
        this.hasVariants = hasVariants;
    }

    public Integer getMaximum() {
        return maximum;
    }

    public void setMaximum(Integer maximum) {
        this.maximum = maximum;
    }

    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public Integer getLeft() {
        return left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public Boolean getOwned() {
        return owned;
    }

    public void setOwned(Boolean owned) {
        this.owned = owned;
    }

    public Boolean getSoldOut() {
        return soldOut;
    }

    public void setSoldOut(Boolean soldOut) {
        this.soldOut = soldOut;
    }

    public List<ScGiftSpvVO> getSpvs() {
        return spvs;
    }

    public void setSpvs(List<ScGiftSpvVO> spvs) {
        this.spvs = spvs;
    }
}
