package com.thebeastshop.cart.enums;

/**
 * @author feiLong.gao
 * @date 2020/1/9
 */
public enum ScCampaignActionEnum {

    /**
     * 选规格
     */
    SPECS("10", "选规格"),
    /**
     * 选阶梯
     */
    LADDER("20", "选阶梯"),
    ;
    private String code;
    private String name;


    ScCampaignActionEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static ScCampaignActionEnum getEnumByCode(String source) {
        for (ScCampaignActionEnum e : values()) {
            if (e.getCode().equals(source)) {
                return e;
            }
        }
        return null;
    }
}
