package com.thebeastshop.cart.model.gift;

import com.thebeastshop.cart.enums.ScJumpModeEnum;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 赠品区间
 *
 * @author feiLong.gao
 * @date 2019/12/25
 */
public class ScGiftSectionVO extends BaseDO {

    private static final long serialVersionUID = 1273165590331905945L;
    private Integer id;                           //活动ID
    private String name;                          //活动名
    private String linkDesc;                      //跳转显示文案
    private Boolean jump = false;                 // 是否跳转
    private ScJumpModeEnum mode = ScJumpModeEnum.CAMPAIGN;   // 跳转Mode
    private Boolean fulfilled;                    // 是否满足活动
    private Boolean useAble;                      // 是否可用
    private Integer maximum;                      // 最大可选数
    private Boolean selectable = Boolean.FALSE;   // 是否可选
    private Boolean editable = Boolean.FALSE;     // 是否可编辑
    private Integer left;                         // 区间所有可选赠品库存，库存为0表示已赠完
    private Boolean soldOut;                      // 是否售罄，售罄标识已赠完
    private List<ScGiftProductVO> giftProducts;   // 赠品商品信息

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLinkDesc() {
        return linkDesc;
    }

    public void setLinkDesc(String linkDesc) {
        this.linkDesc = linkDesc;
    }

    public Boolean getJump() {
        return jump;
    }

    public void setJump(Boolean jump) {
        this.jump = jump;
    }

    public ScJumpModeEnum getMode() {
        return mode;
    }

    public void setMode(ScJumpModeEnum mode) {
        this.mode = mode;
    }

    public Boolean getFulfilled() {
        return fulfilled;
    }

    public void setFulfilled(Boolean fulfilled) {
        this.fulfilled = fulfilled;
    }

    public Boolean getUseAble() {
        return useAble;
    }

    public void setUseAble(Boolean useAble) {
        this.useAble = useAble;
    }

    public Integer getMaximum() {
        return maximum;
    }

    public void setMaximum(Integer maximum) {
        this.maximum = maximum;
    }

    public Boolean getSelectable() {
        return selectable;
    }

    public void setSelectable(Boolean selectable) {
        this.selectable = selectable;
    }

    public Boolean getEditable() {
        return editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Integer getLeft() {
        return left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public Boolean getSoldOut() {
        return soldOut;
    }

    public void setSoldOut(Boolean soldOut) {
        this.soldOut = soldOut;
    }

    public List<ScGiftProductVO> getGiftProducts() {
        return giftProducts;
    }

    public void setGiftProducts(List<ScGiftProductVO> giftProducts) {
        this.giftProducts = giftProducts;
    }
}
