package com.thebeastshop.cart.model;

import com.thebeastshop.cart.enums.ScJumpModeEnum;
import com.thebeastshop.common.BaseDO;

import java.io.Serializable;

/**
 * @author feiLong.gao
 * @date 2019/12/25
 */
public class ScLabel extends BaseDO {

    private static final long serialVersionUID = -4268193357395512049L;
    private ScJumpModeEnum mode = ScJumpModeEnum.TEXT;
    private String type;
    private String typeColor;
    private String typeBgColor = "#000000";
    private String summary;
    private String summaryColor = "#000000";
    private String link;
    private String linkDesc;
    private Integer count;
    private boolean valid = true;
    private boolean jump = true;
    private ScLabel.CampaignVO campaign;
    private ScLabel.PostageVO postage;

    public ScLabel() {
        super();
    }

    public ScLabel(String type, String typeColor, String typeBgColor, String summary, String summaryColor, String link,
                   Integer count, boolean valid) {
        super();
        this.type = type;
        this.typeColor = typeColor;
        this.typeBgColor = typeBgColor;
        this.summary = summary;
        this.summaryColor = summaryColor;
        this.link = link;
        this.count = count;
        this.valid = valid;
    }

    public ScLabel(String type, String typeColor, String typeBgColor, String summary, String summaryColor, String link,
                   String linkDesc, Integer count, boolean valid) {
        super();
        this.type = type;
        this.typeColor = typeColor;
        this.typeBgColor = typeBgColor;
        this.summary = summary;
        this.summaryColor = summaryColor;
        this.link = link;
        this.linkDesc = linkDesc;
        this.count = count;
        this.valid = valid;
    }

    public ScJumpModeEnum getMode() {
        return mode;
    }

    public void setMode(ScJumpModeEnum mode) {
        this.mode = mode;
    }

    public String getType() {
        return type;
    }

    public void setType(final String type) {
        this.type = type;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(final String summary) {
        this.summary = summary;
    }

    public boolean isValid() {
        return valid;
    }

    public void setValid(final boolean valid) {
        this.valid = valid;
    }

    public String getLink() {
        return link;
    }

    public void setLink(final String link) {
        this.link = link;
    }

    public String getLinkDesc() {
        return linkDesc;
    }

    public void setLinkDesc(String linkDesc) {
        this.linkDesc = linkDesc;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(final Integer count) {
        this.count = count;
    }

    public boolean isJump() {
        return jump;
    }

    public void setJump(boolean jump) {
        this.jump = jump;
    }

    public String getSummaryColor() {
        return summaryColor;
    }

    public void setSummaryColor(final String summaryColor) {
        this.summaryColor = summaryColor;
    }

    public String getTypeColor() {
        return typeColor;
    }

    public void setTypeColor(String typeColor) {
        this.typeColor = typeColor;
    }

    public String getTypeBgColor() {
        return typeBgColor;
    }

    public void setTypeBgColor(String typeBgColor) {
        this.typeBgColor = typeBgColor;
    }

    public ScLabel.CampaignVO getCampaign() {
        return campaign;
    }

    public void setCampaign(ScLabel.CampaignVO campaign) {
        this.campaign = campaign;
    }

    public ScLabel.PostageVO getPostage() {
        return postage;
    }

    public void setPostage(ScLabel.PostageVO postage) {
        this.postage = postage;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + hashCode() + ":{" + "type:'" + type + '\'' + ", summary:'" + summary + '\''
                + ", valid:" + valid + ", link:'" + link + '\'' + ", count:" + count + ", summaryColor:'" + summaryColor
                + '\'' + '}';
    }

    public static class PostageVO implements Serializable {

        private static final long serialVersionUID = 1L;

        private Boolean fulfilled = false;

        private String linkDesc;

        public Boolean getFulfilled() {
            return fulfilled;
        }

        public void setFulfilled(Boolean fulfilled) {
            this.fulfilled = fulfilled;
        }

        public String getLinkDesc() {
            return linkDesc;
        }

        public void setLinkDesc(String linkDesc) {
            this.linkDesc = linkDesc;
        }

        @Override
        public String toString() {
            return "PostageVO [fulfilled=" + fulfilled + ", linkDesc=" + linkDesc + "]";
        }

    }

    public static class CampaignVO implements Serializable {

        private static final long serialVersionUID = 1L;

        private Long id;

        private String name;

        private Boolean fulfilled = false;

        private String linkDesc;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Boolean getFulfilled() {
            return fulfilled;
        }

        public void setFulfilled(Boolean fulfilled) {
            this.fulfilled = fulfilled;
        }

        public String getLinkDesc() {
            return linkDesc;
        }

        public void setLinkDesc(String linkDesc) {
            this.linkDesc = linkDesc;
        }

        @Override
        public String toString() {
            return "CampaignVO [id=" + id + ", name=" + name + ", fulfilled=" + fulfilled + ", linkDesc=" + linkDesc
                    + "]";
        }

    }

}
