package com.thebeastshop.cart.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.Cart;
import com.thebeastshop.cart.model.ScRequestPack;
import com.thebeastshop.cart.req.CartPackCondition;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.vo.CartPacksTransferDTO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

/**
 * Created by GFL on 2017/7/12.
 */
public interface CartService {


    /**
     * 获取某用户的购物车
     *
     * @param owner
     * @return 若该用户购物车为空，不返回null，返回一个空的Cart
     */
    Cart getByOwner(MemberVO owner, AccessWayEnum accessWay,String channelCode);

    /**
     * 根据某用户,商品id获取商品包
     *
     * @param owner
     * @param id
     * @return
     */
    CartProductPack getPacksById(MemberVO owner, Long id, AccessWayEnum accessWay,String channelCode);

    /**
     * 根据条件查询
     *
     * @param condition
     * @param accessWay
     * @param owner
     * @return
     */
    List<CartProductPack> findByCondition(CartPackCondition condition, AccessWayEnum accessWay, MemberVO owner,String channelCode);

    /**
     * 根据某用户,商品ids获取商品包
     *
     * @param owner
     * @param ids
     * @return
     */
    List<CartProductPack> getPacksByIds(MemberVO owner, List<Long> ids, AccessWayEnum accessWay,String channelCode);

    /**
     * 将一个商品包加入购物车。 如果该商品包已存在，但主人不是指定购物车的主人（这是偷窃），则抛出异常。
     * 如果该商品包的商品已存在于指定的购物车中，则将该商品包合并到已存在的商品包中。
     *
     * @param owner
     * @param pack
     */
    CartProductPack addPack(MemberVO owner, final CartProductPack pack, AccessWayEnum accessWay,String channelCode);

    /**
     * 将一些商品包加入购物车。 如果该商品包已存在，但主人不是指定购物车的主人（这是偷窃），则抛出异常。
     * 如果该商品包的商品已存在于指定的购物车中，则将该商品包合并到已存在的商品包中。
     *
     * @param owner
     * @param packs
     */
    List<CartProductPack> addPacks(MemberVO owner, List<CartProductPack> packs, AccessWayEnum accessWay,String channelCode);

    void removePacks(MemberVO owner, final Collection<CartProductPack> packs);

    void removePacksById(MemberVO owner, final Collection<Long> packIds);

    /**
     * 移到收藏夹
     *
     * @param transfer
     */
    ServiceResp transfer(CartPacksTransferDTO transfer);

    /**
     * 清空失效商品
     *
     * @param owner
     */
    void clearInvalidPacks(final MemberVO owner, AccessWayEnum accessWay,String channelCode);

    /**
     * 修改购物车中的商品包。 若某商品包已存在购物车里，则修改之；若不存在，则加入之。
     *
     * @param packs
     */
    List<CartProductPack> modifyPack(Collection<CartProductPack> packs, MemberVO owner, AccessWayEnum accessWay,String channelCode);

    /**
     * 将源商品包列表拆分为二，一个是有效的商品包列表，一个是无效的商品包列表，返回商品包和其商品（spv）的对应关系。
     * 无效列表中包括：商品包本身无效的、商品包有效但其商品无效的
     *
     * @param sourcePacks
     * @param validPacks
     * @param invalidPacks
     * @return
     */
    Map<CartProductPack, PsSpvVO> separateInvalid(Collection<CartProductPack> sourcePacks,
                                                  Collection<CartProductPack> validPacks, Collection<CartProductPack> invalidPacks);


    /**
     * 保存权益商品
     * @param pack
     * @return
     */
    CartProductPack saveInterestPack(CartProductPack pack);


    /**
     * 批量保存权益商品
     * @param pack
     * @return
     */
    ServiceResp<Boolean> batchSaveInterestPack(List<CartProductPack> pack);
    
    /**
	 * 合并购物车
	 * 
	 * @param taskId
	 *            合并任务ID
	 * @param mainMemberId
	 *            主账号ID
	 * @param subMemberId
	 *            子账号ID
	 * @return
	 */
    Boolean merge(Long taskId, Long mainMemberId, Long subMemberId);

}
