package com.thebeastshop.cart.resp;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.model.ScPackVO;
import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 迷你购车返回对象
 * @author feiLong.gao
 * @date 2019/12/26
 */
public class ScMiniCartResp extends BaseDO {

    private List<ScPackVO> packs;        //商品包
    private BigDecimal price;                              //最终价格，为 `原价 - 优惠`

    public ScMiniCartResp() {
        this.packs = Lists.newArrayList();
        this.price = BigDecimal.ZERO;
    }

    public ScMiniCartResp(List<ScPackVO> packs, BigDecimal price) {
        this.packs = packs;
        this.price = price;
    }

    public List<ScPackVO> getPacks() {
        return packs;
    }

    public void setPacks(List<ScPackVO> packs) {
        this.packs = packs;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
}
