package com.thebeastshop.cart.model;

import com.thebeastshop.common.BaseDO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * 购物车spv对象
 *
 * @author feiLong.gao
 * @date 2019/12/25
 */
public class ScSpvVO extends BaseDO {


    private Long id;                       // spvId
    private Integer left;                  //剩余库存量
    private String image;                   //默认图片
    private ScBrand brand = new ScBrand();      //品牌
    private int minAmount = 1;              //最小购买数量，默认为 1
    private BigDecimal rawPrice;               //原价
    private BigDecimal price;                   //折扣价
    private BigDecimal preferentialPrice;       // 特别优惠价
    private BigDecimal pointPrice;                //积分价
    private Integer point;                       //兑换积分
    private List<Integer> levelIds;               //兑换会员等级
    private Collection<Integer> group;             //规格维度的选项组合
    private String summary;                       //一句话推荐
    private String spvDesc;                           //描述
    private String name;                              //名称
    private List<String> skuCodes;                   //skuCodes spv包含的所有skuCode
    private String productCode;                         //商品 code
    private List<String> deliveryDates;                 //配送日期
    private String firstDeliveryDate;                      //第一次配送日期
    private Boolean cheap = false;                      //是否低价销售
    private Boolean combined = false;                      // 是否组合
    private Boolean combination = false;                      //组合搭配商品
    private List<ScSpvVO> combinedSingleSpvs;                //组合搭配SPV
    private Quota quota;                              //可购买限额
    private ScPreSellVO presell;                        //是否为预售商品，若不是预售，则为 null
    private PreDeliverVO preDeliver;                       //预计发货
    private ScDiscVO discount;                                //APP专享价
    private FlashSaleVO flashSale;                             //闪购
    private String installDesc;                               //安装描述
    private Boolean isOversea = false;                             //是否海淘
    private Boolean rush = false;                                  //抢购
    private Boolean newcomerTag = false;                           //新人价
    private Boolean onLineOnly = false;                            //官网专享
    private List<ScPriceTagVO> priceTags;                             //价格标签
    private String stockWarn;                                     //库存预警
    private BigDecimal refunds;                                  // 返现基金
    private String refundsName;                              // 返现基金活动名


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getLeft() {
        return left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ScBrand getBrand() {
        return brand;
    }

    public void setBrand(ScBrand brand) {
        this.brand = brand;
    }

    public int getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(int minAmount) {
        this.minAmount = minAmount;
    }

    public BigDecimal getRawPrice() {
        return rawPrice;
    }

    public void setRawPrice(BigDecimal rawPrice) {
        this.rawPrice = rawPrice;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPreferentialPrice() {
        return preferentialPrice;
    }

    public void setPreferentialPrice(BigDecimal preferentialPrice) {
        this.preferentialPrice = preferentialPrice;
    }

    public BigDecimal getPointPrice() {
        return pointPrice;
    }

    public void setPointPrice(BigDecimal pointPrice) {
        this.pointPrice = pointPrice;
    }

    public Integer getPoint() {
        return point;
    }

    public void setPoint(Integer point) {
        this.point = point;
    }

    public List<Integer> getLevelIds() {
        return levelIds;
    }

    public void setLevelIds(List<Integer> levelIds) {
        this.levelIds = levelIds;
    }

    public Collection<Integer> getGroup() {
        return group;
    }

    public void setGroup(Collection<Integer> group) {
        this.group = group;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSpvDesc() {
        return spvDesc;
    }

    public void setSpvDesc(String spvDesc) {
        this.spvDesc = spvDesc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public List<String> getDeliveryDates() {
        return deliveryDates;
    }

    public void setDeliveryDates(List<String> deliveryDates) {
        this.deliveryDates = deliveryDates;
    }

    public String getFirstDeliveryDate() {
        return firstDeliveryDate;
    }

    public void setFirstDeliveryDate(String firstDeliveryDate) {
        this.firstDeliveryDate = firstDeliveryDate;
    }

    public Boolean getCheap() {
        return cheap;
    }

    public void setCheap(Boolean cheap) {
        this.cheap = cheap;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public Boolean getCombination() {
        return combination;
    }

    public void setCombination(Boolean combination) {
        this.combination = combination;
    }

    public List<ScSpvVO> getCombinedSingleSpvs() {
        return combinedSingleSpvs;
    }

    public void setCombinedSingleSpvs(List<ScSpvVO> combinedSingleSpvs) {
        this.combinedSingleSpvs = combinedSingleSpvs;
    }

    public Quota getQuota() {
        return quota;
    }

    public void setQuota(Quota quota) {
        this.quota = quota;
    }

    public ScPreSellVO getPresell() {
        return presell;
    }

    public void setPresell(ScPreSellVO presell) {
        this.presell = presell;
    }

    public PreDeliverVO getPreDeliver() {
        return preDeliver;
    }

    public void setPreDeliver(PreDeliverVO preDeliver) {
        this.preDeliver = preDeliver;
    }

    public ScDiscVO getDiscount() {
        return discount;
    }

    public void setDiscount(ScDiscVO discount) {
        this.discount = discount;
    }

    public FlashSaleVO getFlashSale() {
        return flashSale;
    }

    public void setFlashSale(FlashSaleVO flashSale) {
        this.flashSale = flashSale;
    }

    public String getInstallDesc() {
        return installDesc;
    }

    public void setInstallDesc(String installDesc) {
        this.installDesc = installDesc;
    }

    public Boolean getOversea() {
        return isOversea;
    }

    public void setOversea(Boolean oversea) {
        isOversea = oversea;
    }

    public Boolean getRush() {
        return rush;
    }

    public void setRush(Boolean rush) {
        this.rush = rush;
    }

    public Boolean getNewcomerTag() {
        return newcomerTag;
    }

    public void setNewcomerTag(Boolean newcomerTag) {
        this.newcomerTag = newcomerTag;
    }

    public Boolean getOnLineOnly() {
        return onLineOnly;
    }

    public void setOnLineOnly(Boolean onLineOnly) {
        this.onLineOnly = onLineOnly;
    }

    public List<ScPriceTagVO> getPriceTags() {
        return priceTags;
    }

    public void setPriceTags(List<ScPriceTagVO> priceTags) {
        this.priceTags = priceTags;
    }

    public String getStockWarn() {
        return stockWarn;
    }

    public void setStockWarn(String stockWarn) {
        this.stockWarn = stockWarn;
    }

    public BigDecimal getRefunds() {
        return refunds;
    }

    public void setRefunds(BigDecimal refunds) {
        this.refunds = refunds;
    }

    public String getRefundsName() {
        return refundsName;
    }

    public void setRefundsName(String refundsName) {
        this.refundsName = refundsName;
    }

    /**
     * 购买限制
     */
    public static class Quota implements Serializable {
        private static final long serialVersionUID = 1L;
        /**
         * 当前剩下的可购买额度
         */
        private int left = -1;
        /**
         * 总可购买额度
         */
        private int total = -1;

        public int getLeft() {
            return left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getTotal() {
            return total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

    }


    /**
     * 预计发货
     *
     * @author xiang.gao
     * @date 2019/02/14
     */
    public static class PreDeliverVO extends BaseDO {

        /**
         * 0:预售 1:来单
         */
        private Integer type;
        /**
         * 预计发货时间
         */
        private Date deliverAt;
        /**
         * 发货信息描述
         */
        private String content;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Date getDeliverAt() {
            return deliverAt;
        }

        public void setDeliverAt(Date deliverAt) {
            this.deliverAt = deliverAt;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }


    /**
     * 闪购
     *
     * @author Yawei-wang
     */
    public static class FlashSaleVO implements Serializable {

        /**
         * @Field long serialVersionUID
         */
        private static final long serialVersionUID = 1L;

        /**
         * 如果不是闪购，或者闪购有效期之外，则为 null
         */
        private Timestamp expiresAt;// 单位秒，距离闪购结束的时间

        private boolean soldOut;// 闪购限额已经售光。如果在闪购有效期内，且闪购限额已经售光，则商品不能购买，显示为
        // soldout。

        public boolean isSoldOut() {
            return soldOut;
        }

        public Timestamp getExpiresAt() {
            return expiresAt;
        }

        public void setExpiresAt(Timestamp expiresAt) {
            this.expiresAt = expiresAt;
        }

        public void setSoldOut(boolean soldOut) {
            this.soldOut = soldOut;
        }

        @Override
        public String toString() {
            return "FlashSaleVO [expiresAt =" + expiresAt + ", soldOut =" + soldOut + "]";
        }
    }


}
