package com.thebeastshop.cart.enums;

public enum CartSceneEnum {

    CART(1,"cart"),
    ;

    private Integer code;
    private String name;

    CartSceneEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CartPackSourceEnum getEnumByCode(Integer code) {
        for (CartPackSourceEnum e : CartPackSourceEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static CartPackSourceEnum getEnumByName(String name) {
        for (CartPackSourceEnum e : CartPackSourceEnum.values()) {
            if (e.getCode().equals(name)) {
                return e;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }
}
