package com.thebeastshop.cart.model.gift;

import com.thebeastshop.cart.model.ScProductCard;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 定制卡片，用于商品包
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2020/11/10
 */
public class ScCustomCard extends BaseDO {

    public interface CardStyle{
        //BASE-普通样式 LOVER-情人节样式;
        String BASE = "BASE";
        String LOVER = "LOVER";
    }

    private Boolean canCustom = Boolean.FALSE;

    private Boolean customized = Boolean.FALSE;

    private String cardStyle=CardStyle.BASE;

    private Integer total = 0;

    private Integer blankNum = 0;

    private Integer writeNum = 0;

    private List<ScProductCard> cards;

    public ScCustomCard() {
    }

    public ScCustomCard(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public ScCustomCard(Boolean canCustom, Integer total) {
        this.canCustom = canCustom;
        this.total = total;
    }

    public ScCustomCard(Boolean canCustom, Integer total,String cardStyle) {
        this.canCustom = canCustom;
        this.total = total;
        this.cardStyle = cardStyle;
    }

    public Boolean getCanCustom() {
        return canCustom;
    }

    public void setCanCustom(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public Boolean getCustomized() {
        return customized;
    }

    public void setCustomized(Boolean customized) {
        this.customized = customized;
    }

    public String getCardStyle() {
        return cardStyle;
    }

    public void setCardStyle(String cardStyle) {
        this.cardStyle = cardStyle;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getBlankNum() {
        return blankNum;
    }

    public void setBlankNum(Integer blankNum) {
        this.blankNum = blankNum;
    }

    public Integer getWriteNum() {
        return writeNum;
    }

    public void setWriteNum(Integer writeNum) {
        this.writeNum = writeNum;
    }

    public List<ScProductCard> getCards() {
        return cards;
    }

    public void setCards(List<ScProductCard> cards) {
        this.cards = cards;
    }

    public void resetTotal(Integer total){
        if(this.total > total){
            this.total = total;
        }

        if(writeNum > total){
            writeNum = total;
            blankNum = 0;
            cards = cards.subList(0,writeNum-1);
            return;
        }

        if(writeNum == total){
            blankNum = 0;
            return;
        }

        if(writeNum < total && (total-writeNum)< blankNum){
            blankNum = total-writeNum;
        }
    }
}
