package com.thebeastshop.cart.service;

import com.thebeastshop.cart.enums.FavoriteExtTypeEnum;
import com.thebeastshop.cart.req.FavoriteCondition;
import com.thebeastshop.cart.vo.Favorite;
import com.thebeastshop.common.PageQueryResp;

import java.util.Collection;
import java.util.List;

/**
 * 收藏服务
 *
 * @author Paul-xiong
 */
public interface FavoriteService {

    /**
     * 创建收藏
     *
     * @param obj 收藏对象
     * @return
     */
    Favorite create(Favorite obj);

    Collection<Favorite> create(final Collection<Favorite> favorites);

    /**
     * 删除收藏
     *
     * @param id 收藏id
     * @return
     */
    boolean delete(Long id);

    boolean batchDelete(List<Long> itemIds, FavoriteExtTypeEnum favoriteExtType, Long ownerId);

    /**
     * 根据id获取收藏
     *
     * @param id 收藏id
     * @return
     */
    Favorite getById(Long id);

    /**
     * 根据条件查询收藏列表
     *
     * @param condition 条件
     * @return
     */
    List<Favorite> getByCondition(FavoriteCondition condition);

    /**
     * 根据条件分页查询收藏信息
     *
     * @param condition 条件
     * @param offset    起始行
     * @param limit     限制行数
     * @return
     */
    PageQueryResp<Favorite> find(FavoriteCondition condition, Integer offset, Integer limit);

    /**
     * 判断是否已收藏
     *
     * @param obj 收藏对象
     * @return
     */
    boolean checkIsExist(Favorite obj);

    /**
     * 合并收藏
     *
     * @param taskId       合并任务ID
     * @param mainMemberId 主账号ID
     * @param subMemberId  子账号ID
     * @return
     */
    Boolean merge(Long taskId, Long mainMemberId, Long subMemberId);

}
