package com.thebeastshop.cart.resp;

import com.thebeastshop.cart.model.ScAnnouncementVO;
import com.thebeastshop.cart.model.ScGroupsVO;
import com.thebeastshop.cart.model.ScPackVO;
import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 购车返回对象
 * @author feiLong.gao
 * @date 2019/12/26
 */
public class ScCartResp extends BaseDO {

    private List<ScAnnouncementVO> announcements;          //公告信息
    private List<ScPackVO> invalidPacks;                    //失效商品包
    private List<ScGroupsVO> groups;                        //购物车商品组，比如普通商品，海外商品，第三方发货商品，会各属于自己的商品组
    private BigDecimal savedPrice;                         //优惠减免的价格: 原价-应付金额
    private BigDecimal price;                              //最终价格，为 `原价 - 优惠`

    public List<ScAnnouncementVO> getAnnouncements() {
        return announcements;
    }

    public void setAnnouncements(List<ScAnnouncementVO> announcements) {
        this.announcements = announcements;
    }

    public List<ScPackVO> getInvalidPacks() {
        return invalidPacks;
    }

    public void setInvalidPacks(List<ScPackVO> invalidPacks) {
        this.invalidPacks = invalidPacks;
    }

    public List<ScGroupsVO> getGroups() {
        return groups;
    }

    public void setGroups(List<ScGroupsVO> groups) {
        this.groups = groups;
    }

    public BigDecimal getSavedPrice() {
        return savedPrice;
    }

    public void setSavedPrice(BigDecimal savedPrice) {
        this.savedPrice = savedPrice;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
}
