package com.thebeastshop.cart.model.gift;

import com.thebeastshop.cart.model.ScProductCard;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 定制卡片，用于商品包
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2020/11/10
 */
public class ScCustomCard extends BaseDO {

    private Boolean canCustom = Boolean.FALSE;

    private Boolean customized = Boolean.FALSE;

    private Integer total = 0;

    private Integer blankNum = 0;

    private Integer writeNum = 0;

    private List<ScProductCard> cards;

    public ScCustomCard() {
    }

    public ScCustomCard(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public ScCustomCard(Boolean canCustom, Integer total) {
        this.canCustom = canCustom;
        this.total = total;
    }

    public Boolean getCanCustom() {
        return canCustom;
    }

    public void setCanCustom(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public Boolean getCustomized() {
        return customized;
    }

    public void setCustomized(Boolean customized) {
        this.customized = customized;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getBlankNum() {
        return blankNum;
    }

    public void setBlankNum(Integer blankNum) {
        this.blankNum = blankNum;
    }

    public Integer getWriteNum() {
        return writeNum;
    }

    public void setWriteNum(Integer writeNum) {
        this.writeNum = writeNum;
    }

    public List<ScProductCard> getCards() {
        return cards;
    }

    public void setCards(List<ScProductCard> cards) {
        this.cards = cards;
    }

    public void resetTotal(Integer total){
        if(this.total > total){
            this.total = total;
        }

        if(writeNum > total){
            writeNum = total;
            blankNum = 0;
            cards = cards.subList(0,writeNum-1);
            return;
        }

        if(writeNum == total){
            blankNum = 0;
            return;
        }

        if(writeNum < total && (total-writeNum)< blankNum){
            blankNum = total-writeNum;
        }
    }
}
