package com.thebeastshop.cart.model;

import com.thebeastshop.common.BaseDO;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 购物车商品卡片
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2020/11/10
 */
public class ScProductCard extends BaseDO {

    public interface CardType{
        String NONE = "NONE";
        String EMPTY = "EMPTY";
        String WRITE = "WRITE";
        String VOICE = "VOICE";
    }
    /**
     * NONE(0, "不需要"),
     *
     * 	EMPTY(1, "空白"),
     *
     * 	WRITE(2, "代写"),
     *
     * 	VOICE(3, "语音卡");
     * 卡片类型 ： 0-不需要 1-空白 2-代写 3-语音
     */
    private String type;

    /**
     * 卡片抬头信息
     */
    private String to;
    /**
     * 卡片正文
     */
    private String content;

    /**
     * 卡片落款信息
     */
    private String from;

    /**
     * 数量
     */
    private Integer count = 0;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("type", type)
                .append("to", to)
                .append("content", content)
                .append("from", from)
                .append("count", count)
                .toString();
    }
}
